/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.HttpCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkSystemSetting;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util.UserAgentUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.internal.util.EC2MetadataUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util.HttpResourcesUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public final class InstanceProfileCredentialsProvider
extends HttpCredentialsProvider {
    private static final String EC2_METADATA_TOKEN_HEADER = "x-aws-ec2-metadata-token";
    private static final String SECURITY_CREDENTIALS_RESOURCE = "/latest/meta-data/iam/security-credentials/";

    private InstanceProfileCredentialsProvider(BuilderImpl builder) {
        super(builder);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static InstanceProfileCredentialsProvider create() {
        return InstanceProfileCredentialsProvider.builder().build();
    }

    @Override
    protected ResourcesEndpointProvider getCredentialsEndpointProvider() {
        return new InstanceProviderCredentialsEndpointProvider(this.getToken());
    }

    @Override
    protected boolean isLocalCredentialLoadingDisabled() {
        return SdkSystemSetting.AWS_EC2_METADATA_DISABLED.getBooleanValueOrThrow();
    }

    public String toString() {
        return ToString.create("InstanceProfileCredentialsProvider");
    }

    private String getToken() {
        return EC2MetadataUtils.getToken();
    }

    private static ResourcesEndpointProvider includeTokenHeader(final ResourcesEndpointProvider provider, final String token) {
        return new ResourcesEndpointProvider(){

            @Override
            public URI endpoint() throws IOException {
                return provider.endpoint();
            }

            @Override
            public Map<String, String> headers() {
                HashMap<String, String> headers = new HashMap<String, String>(provider.headers());
                headers.put(InstanceProfileCredentialsProvider.EC2_METADATA_TOKEN_HEADER, token);
                return headers;
            }
        };
    }

    private static final class BuilderImpl
    extends HttpCredentialsProvider.BuilderImpl<InstanceProfileCredentialsProvider, Builder>
    implements Builder {
        private BuilderImpl() {
            super.asyncThreadName("instance-profile-credentials-provider");
        }

        @Override
        public InstanceProfileCredentialsProvider build() {
            return new InstanceProfileCredentialsProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialsProvider.Builder<InstanceProfileCredentialsProvider, Builder> {
        @Override
        public InstanceProfileCredentialsProvider build();
    }

    private static final class InstanceProviderCredentialsEndpointProvider
    implements ResourcesEndpointProvider {
        private final String metadataToken;

        private InstanceProviderCredentialsEndpointProvider(String metadataToken) {
            this.metadataToken = metadataToken;
        }

        @Override
        public URI endpoint() throws IOException {
            String securityCredentialsList;
            String[] securityCredentials;
            String host = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT.getStringValueOrThrow();
            URI endpoint = URI.create(host + InstanceProfileCredentialsProvider.SECURITY_CREDENTIALS_RESOURCE);
            ResourcesEndpointProvider endpointProvider = () -> endpoint;
            if (this.metadataToken != null) {
                endpointProvider = InstanceProfileCredentialsProvider.includeTokenHeader(endpointProvider, this.metadataToken);
            }
            if ((securityCredentials = (securityCredentialsList = HttpResourcesUtils.instance().readResource(endpointProvider)).trim().split("\n")).length == 0) {
                throw SdkClientException.builder().message("Unable to load credentials path").build();
            }
            return URI.create(host + InstanceProfileCredentialsProvider.SECURITY_CREDENTIALS_RESOURCE + securityCredentials[0]);
        }

        @Override
        public Map<String, String> headers() {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("User-Agent", UserAgentUtils.getUserAgent());
            requestHeaders.put("Accept", "*/*");
            requestHeaders.put("Connection", "keep-alive");
            if (this.metadataToken != null) {
                requestHeaders.put(InstanceProfileCredentialsProvider.EC2_METADATA_TOKEN_HEADER, this.metadataToken);
            }
            return requestHeaders;
        }
    }
}

