/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.util.json.JacksonUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util.HttpResourcesUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ComparableUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.DateUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.cache.CachedSupplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.cache.NonBlocking;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.cache.RefreshResult;

@SdkProtectedApi
public abstract class HttpCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private final Optional<CachedSupplier<AwsCredentials>> credentialsCache;

    protected HttpCredentialsProvider(BuilderImpl<?, ?> builder) {
        this(((BuilderImpl)builder).asyncCredentialUpdateEnabled, ((BuilderImpl)builder).asyncThreadName);
    }

    HttpCredentialsProvider(boolean asyncCredentialUpdateEnabled, String asyncThreadName) {
        if (this.isLocalCredentialLoadingDisabled()) {
            this.credentialsCache = Optional.empty();
        } else {
            CachedSupplier.Builder cacheBuilder = CachedSupplier.builder(this::refreshCredentials);
            if (asyncCredentialUpdateEnabled) {
                cacheBuilder.prefetchStrategy(new NonBlocking(asyncThreadName));
            }
            this.credentialsCache = Optional.of(cacheBuilder.build());
        }
    }

    protected abstract ResourcesEndpointProvider getCredentialsEndpointProvider();

    protected boolean isLocalCredentialLoadingDisabled() {
        return false;
    }

    private RefreshResult<AwsCredentials> refreshCredentials() {
        try {
            String credentialsResponse = HttpResourcesUtils.instance().readResource(this.getCredentialsEndpointProvider());
            JsonNode node = JacksonUtils.sensitiveJsonNodeOf(credentialsResponse);
            JsonNode accessKey = node.get("AccessKeyId");
            JsonNode secretKey = node.get("SecretAccessKey");
            JsonNode token = node.get("Token");
            JsonNode expirationNode = node.get("Expiration");
            Validate.notNull(accessKey, "Failed to load access key.", new Object[0]);
            Validate.notNull(secretKey, "Failed to load secret key.", new Object[0]);
            AwsBasicCredentials credentials = token == null ? AwsBasicCredentials.create(accessKey.asText(), secretKey.asText()) : AwsSessionCredentials.create(accessKey.asText(), secretKey.asText(), token.asText());
            Instant expiration = this.getExpiration(expirationNode).orElse(null);
            if (expiration != null && Instant.now().isAfter(expiration)) {
                throw SdkClientException.builder().message("Credentials obtained from metadata service are already expired.").build();
            }
            return RefreshResult.builder(credentials).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
        }
        catch (SdkClientException e) {
            throw e;
        }
        catch (JsonMappingException e) {
            throw SdkClientException.builder().message("Unable to parse response returned from service endpoint.").cause(e).build();
        }
        catch (IOException | RuntimeException e) {
            throw SdkClientException.builder().message("Unable to load credentials from service endpoint.").cause(e).build();
        }
    }

    private Optional<Instant> getExpiration(JsonNode expirationNode) {
        return Optional.ofNullable(expirationNode).map(node -> {
            String expirationValue = node.asText().replaceAll("\\+0000$", "Z");
            try {
                return DateUtils.parseIso8601Date(expirationValue);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Unable to parse credentials expiration date from metadata service.", e);
            }
        });
    }

    private Instant getStaleTime(Instant expiration) {
        return expiration == null ? null : expiration.minus(Duration.ofMinutes(1L));
    }

    private Instant getPrefetchTime(Instant expiration) {
        Instant oneHourFromNow = Instant.now().plus(Duration.ofHours(1L));
        return expiration == null ? oneHourFromNow : (Instant)ComparableUtils.minimum((Comparable[])new Instant[]{oneHourFromNow, expiration.minus(Duration.ofMinutes(15L))});
    }

    @Override
    public AwsCredentials resolveCredentials() {
        if (this.isLocalCredentialLoadingDisabled()) {
            throw SdkClientException.builder().message("Loading credentials from local endpoint is disabled. Unable to load credentials from service endpoint.").build();
        }
        return this.credentialsCache.map(CachedSupplier::get).orElseThrow(() -> SdkClientException.builder().message("Unable to load credentials from service endpoint").build());
    }

    @Override
    public void close() {
        this.credentialsCache.ifPresent(CachedSupplier::close);
    }

    protected static abstract class BuilderImpl<TypeToBuildT extends HttpCredentialsProvider, BuilderT extends Builder>
    implements Builder<TypeToBuildT, BuilderT> {
        private boolean asyncCredentialUpdateEnabled = false;
        private String asyncThreadName;

        protected BuilderImpl() {
        }

        @Override
        public BuilderT asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return (BuilderT)this;
        }

        public void setAsyncCredentialUpdateEnabled(boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled(asyncCredentialUpdateEnabled);
        }

        @Override
        public BuilderT asyncThreadName(String asyncThreadName) {
            this.asyncThreadName = asyncThreadName;
            return (BuilderT)this;
        }

        public void setAsyncThreadName(String asyncThreadName) {
            this.asyncThreadName(asyncThreadName);
        }
    }

    public static interface Builder<TypeToBuildT extends HttpCredentialsProvider, BuilderT extends Builder> {
        public BuilderT asyncCredentialUpdateEnabled(Boolean var1);

        public BuilderT asyncThreadName(String var1);

        public TypeToBuildT build();
    }
}

