/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkTestInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.HttpCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.internal.ContainerCredentialsRetryPolicy;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkSystemSetting;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util.ResourcesEndpointRetryPolicy;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.StringUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public final class ContainerCredentialsProvider
extends HttpCredentialsProvider {
    private final ResourcesEndpointProvider credentialsEndpointProvider;

    private ContainerCredentialsProvider(BuilderImpl builder) {
        super(builder);
        this.credentialsEndpointProvider = builder.credentialsEndpointProvider;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    protected ResourcesEndpointProvider getCredentialsEndpointProvider() {
        return this.credentialsEndpointProvider;
    }

    public String toString() {
        return ToString.create("ContainerCredentialsProvider");
    }

    static final class BuilderImpl
    extends HttpCredentialsProvider.BuilderImpl<ContainerCredentialsProvider, Builder>
    implements Builder {
        private ResourcesEndpointProvider credentialsEndpointProvider = new ContainerCredentialsEndpointProvider();

        BuilderImpl() {
            super.asyncThreadName("container-credentials-provider");
        }

        @SdkTestInternalApi
        Builder credentialsEndpointProvider(ResourcesEndpointProvider credentialsEndpointProvider) {
            this.credentialsEndpointProvider = credentialsEndpointProvider;
            return this;
        }

        @Override
        public ContainerCredentialsProvider build() {
            return new ContainerCredentialsProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialsProvider.Builder<ContainerCredentialsProvider, Builder> {
        @Override
        public ContainerCredentialsProvider build();
    }

    static final class ContainerCredentialsEndpointProvider
    implements ResourcesEndpointProvider {
        private static final Set<String> ALLOWED_HOSTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("localhost", "127.0.0.1")));

        ContainerCredentialsEndpointProvider() {
        }

        @Override
        public URI endpoint() throws IOException {
            if (!SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_RELATIVE_URI.getStringValue().isPresent() && !SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.getStringValue().isPresent()) {
                throw SdkClientException.builder().message(String.format("Cannot fetch credentials from container - neither %s or %s environment variables are set.", SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.environmentVariable(), SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_RELATIVE_URI.environmentVariable())).build();
            }
            try {
                return SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_RELATIVE_URI.getStringValue().map(this::createUri).orElseGet(this::createGenericContainerUrl);
            }
            catch (SdkClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw SdkClientException.builder().message("Unable to fetch credentials from container.").cause(e).build();
            }
        }

        @Override
        public ResourcesEndpointRetryPolicy retryPolicy() {
            return new ContainerCredentialsRetryPolicy();
        }

        @Override
        public Map<String, String> headers() {
            return SdkSystemSetting.AWS_CONTAINER_AUTHORIZATION_TOKEN.getStringValue().filter(StringUtils::isNotBlank).map(t -> Collections.singletonMap("Authorization", t)).orElseGet(Collections::emptyMap);
        }

        private URI createUri(String relativeUri) {
            return URI.create(SdkSystemSetting.AWS_CONTAINER_SERVICE_ENDPOINT.getStringValueOrThrow() + relativeUri);
        }

        private URI createGenericContainerUrl() {
            URI uri = URI.create(SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.getStringValueOrThrow());
            if (!ALLOWED_HOSTS.contains(uri.getHost())) {
                throw SdkClientException.builder().message(String.format("The full URI (%s) contained within environment variable %s has an invalid host. Host can only be one of [%s].", uri, SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.environmentVariable(), String.join((CharSequence)",", ALLOWED_HOSTS))).build();
            }
            return uri;
        }
    }
}

