/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.typesafe.netty.http;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.kinesis.shaded.com.typesafe.netty.CancelledSubscriber;
import org.apache.flink.kinesis.shaded.com.typesafe.netty.HandlerPublisher;
import org.apache.flink.kinesis.shaded.com.typesafe.netty.HandlerSubscriber;
import org.apache.flink.kinesis.shaded.com.typesafe.netty.http.DelegateStreamedHttpRequest;
import org.apache.flink.kinesis.shaded.com.typesafe.netty.http.EmptyHttpRequest;
import org.apache.flink.kinesis.shaded.com.typesafe.netty.http.HttpStreamsHandler;
import org.apache.flink.kinesis.shaded.com.typesafe.netty.http.WebSocketHttpResponse;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandler;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelPipeline;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.HttpContent;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.HttpUtil;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.apache.flink.kinesis.shaded.org.reactivestreams.Publisher;

public class HttpStreamsServerHandler
extends HttpStreamsHandler<HttpRequest, HttpResponse> {
    private HttpRequest lastRequest = null;
    private HttpStreamsHandler.Outgoing webSocketResponse = null;
    private int inFlight = 0;
    private boolean continueExpected = true;
    private boolean sendContinue = false;
    private boolean close = false;
    private final List<ChannelHandler> dependentHandlers;

    public HttpStreamsServerHandler() {
        this(Collections.emptyList());
    }

    public HttpStreamsServerHandler(List<ChannelHandler> dependentHandlers) {
        super(HttpRequest.class, HttpResponse.class);
        this.dependentHandlers = dependentHandlers;
    }

    @Override
    protected boolean hasBody(HttpRequest request) {
        return HttpUtil.getContentLength((HttpMessage)request, 0) != 0 || HttpUtil.isTransferEncodingChunked(request);
    }

    @Override
    protected HttpRequest createEmptyMessage(HttpRequest request) {
        return new EmptyHttpRequest(request);
    }

    @Override
    protected HttpRequest createStreamedMessage(HttpRequest httpRequest, Publisher<HttpContent> stream) {
        return new DelegateStreamedHttpRequest(httpRequest, stream);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.continueExpected = false;
        this.sendContinue = false;
        if (msg instanceof HttpRequest) {
            HttpRequest request;
            this.lastRequest = request = (HttpRequest)msg;
            if (HttpUtil.is100ContinueExpected(request)) {
                this.continueExpected = true;
            }
        }
        super.channelRead(ctx, msg);
    }

    @Override
    protected void receivedInMessage(ChannelHandlerContext ctx) {
        ++this.inFlight;
    }

    @Override
    protected void sentOutMessage(ChannelHandlerContext ctx) {
        --this.inFlight;
        if (this.inFlight == 1 && this.continueExpected && this.sendContinue) {
            ctx.writeAndFlush(new DefaultFullHttpResponse(this.lastRequest.protocolVersion(), HttpResponseStatus.CONTINUE));
            this.sendContinue = false;
            this.continueExpected = false;
        }
        if (this.close) {
            ctx.close();
        }
    }

    @Override
    protected void unbufferedWrite(ChannelHandlerContext ctx, HttpStreamsHandler.Outgoing out) {
        if (out.message instanceof WebSocketHttpResponse) {
            if (this.lastRequest instanceof FullHttpRequest || !this.hasBody(this.lastRequest)) {
                this.handleWebSocketResponse(ctx, out);
            } else {
                this.webSocketResponse = out;
            }
        } else {
            String connection = ((HttpResponse)out.message).headers().get(HttpHeaderNames.CONNECTION);
            if (this.lastRequest.protocolVersion().isKeepAliveDefault()) {
                if ("close".equalsIgnoreCase(connection)) {
                    this.close = true;
                }
            } else if (!"keep-alive".equalsIgnoreCase(connection)) {
                this.close = true;
            }
            if (this.inFlight == 1 && this.continueExpected) {
                HttpUtil.setKeepAlive(out.message, false);
                this.close = true;
                this.continueExpected = false;
            }
            if (!HttpUtil.isContentLengthSet(out.message) && !HttpUtil.isTransferEncodingChunked(out.message) && this.canHaveBody((HttpResponse)out.message)) {
                HttpUtil.setKeepAlive(out.message, false);
                this.close = true;
            }
            super.unbufferedWrite(ctx, out);
        }
    }

    private boolean canHaveBody(HttpResponse message) {
        HttpResponseStatus status = message.status();
        return status != HttpResponseStatus.CONTINUE && status != HttpResponseStatus.SWITCHING_PROTOCOLS && status != HttpResponseStatus.PROCESSING && status != HttpResponseStatus.NO_CONTENT && status != HttpResponseStatus.NOT_MODIFIED;
    }

    @Override
    protected void consumedInMessage(ChannelHandlerContext ctx) {
        if (this.webSocketResponse != null) {
            this.handleWebSocketResponse(ctx, this.webSocketResponse);
            this.webSocketResponse = null;
        }
    }

    private void handleWebSocketResponse(ChannelHandlerContext ctx, HttpStreamsHandler.Outgoing out) {
        WebSocketHttpResponse response = (WebSocketHttpResponse)out.message;
        WebSocketServerHandshaker handshaker = response.handshakerFactory().newHandshaker(this.lastRequest);
        if (handshaker == null) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UPGRADE_REQUIRED);
            res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)WebSocketVersion.V13.toHttpHeaderValue());
            HttpUtil.setContentLength(res, 0L);
            super.unbufferedWrite(ctx, new HttpStreamsHandler.Outgoing((HttpStreamsHandler)this, (HttpMessage)res, out.promise));
            response.subscribe(new CancelledSubscriber());
        } else {
            ChannelPipeline pipeline = ctx.pipeline();
            HandlerPublisher<WebSocketFrame> publisher = new HandlerPublisher<WebSocketFrame>(ctx.executor(), WebSocketFrame.class);
            HandlerSubscriber subscriber = new HandlerSubscriber(ctx.executor());
            pipeline.addAfter(ctx.executor(), ctx.name(), "websocket-subscriber", subscriber);
            pipeline.addAfter(ctx.executor(), ctx.name(), "websocket-publisher", publisher);
            ctx.pipeline().remove(ctx.name());
            handshaker.handshake(ctx.channel(), new EmptyHttpRequest(this.lastRequest));
            response.subscribe(subscriber);
            publisher.subscribe(response);
        }
    }

    @Override
    protected void bodyRequested(ChannelHandlerContext ctx) {
        if (this.continueExpected) {
            if (this.inFlight == 1) {
                ctx.writeAndFlush(new DefaultFullHttpResponse(this.lastRequest.protocolVersion(), HttpResponseStatus.CONTINUE));
                this.continueExpected = false;
            } else {
                this.sendContinue = true;
            }
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        for (ChannelHandler dependent : this.dependentHandlers) {
            try {
                ctx.pipeline().remove(dependent);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }
}

