/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.ThreadSafe;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.AbstractErrorUnmarshaller;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.node.NullNode;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(new PropertyNamingStrategy.PascalCaseStrategy());
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        if (jsonContent == null || NullNode.instance.equals(jsonContent)) {
            return null;
        }
        return (AmazonServiceException)MAPPER.treeToValue(jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }
}

