/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.RecordColumn;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.RecordFormat;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform.SourceSchemaMarshaller;

public class SourceSchema
implements Serializable,
Cloneable,
StructuredPojo {
    private RecordFormat recordFormat;
    private String recordEncoding;
    private List<RecordColumn> recordColumns;

    public void setRecordFormat(RecordFormat recordFormat) {
        this.recordFormat = recordFormat;
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat;
    }

    public SourceSchema withRecordFormat(RecordFormat recordFormat) {
        this.setRecordFormat(recordFormat);
        return this;
    }

    public void setRecordEncoding(String recordEncoding) {
        this.recordEncoding = recordEncoding;
    }

    public String getRecordEncoding() {
        return this.recordEncoding;
    }

    public SourceSchema withRecordEncoding(String recordEncoding) {
        this.setRecordEncoding(recordEncoding);
        return this;
    }

    public List<RecordColumn> getRecordColumns() {
        return this.recordColumns;
    }

    public void setRecordColumns(Collection<RecordColumn> recordColumns) {
        if (recordColumns == null) {
            this.recordColumns = null;
            return;
        }
        this.recordColumns = new ArrayList<RecordColumn>(recordColumns);
    }

    public SourceSchema withRecordColumns(RecordColumn ... recordColumns) {
        if (this.recordColumns == null) {
            this.setRecordColumns(new ArrayList<RecordColumn>(recordColumns.length));
        }
        for (RecordColumn ele : recordColumns) {
            this.recordColumns.add(ele);
        }
        return this;
    }

    public SourceSchema withRecordColumns(Collection<RecordColumn> recordColumns) {
        this.setRecordColumns(recordColumns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecordFormat() != null) {
            sb.append("RecordFormat: ").append(this.getRecordFormat()).append(",");
        }
        if (this.getRecordEncoding() != null) {
            sb.append("RecordEncoding: ").append(this.getRecordEncoding()).append(",");
        }
        if (this.getRecordColumns() != null) {
            sb.append("RecordColumns: ").append(this.getRecordColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSchema)) {
            return false;
        }
        SourceSchema other = (SourceSchema)obj;
        if (other.getRecordFormat() == null ^ this.getRecordFormat() == null) {
            return false;
        }
        if (other.getRecordFormat() != null && !other.getRecordFormat().equals(this.getRecordFormat())) {
            return false;
        }
        if (other.getRecordEncoding() == null ^ this.getRecordEncoding() == null) {
            return false;
        }
        if (other.getRecordEncoding() != null && !other.getRecordEncoding().equals(this.getRecordEncoding())) {
            return false;
        }
        if (other.getRecordColumns() == null ^ this.getRecordColumns() == null) {
            return false;
        }
        return other.getRecordColumns() == null || other.getRecordColumns().equals(this.getRecordColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecordFormat() == null ? 0 : this.getRecordFormat().hashCode());
        hashCode = 31 * hashCode + (this.getRecordEncoding() == null ? 0 : this.getRecordEncoding().hashCode());
        hashCode = 31 * hashCode + (this.getRecordColumns() == null ? 0 : this.getRecordColumns().hashCode());
        return hashCode;
    }

    public SourceSchema clone() {
        try {
            return (SourceSchema)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceSchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

