/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.interfaces;

import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.Lease;

public interface ILeaseManager<T extends Lease> {
    public boolean createLeaseTableIfNotExists(Long var1, Long var2) throws ProvisionedThroughputException, DependencyException;

    public boolean leaseTableExists() throws DependencyException;

    public boolean waitUntilLeaseTableExists(long var1, long var3) throws DependencyException;

    public List<T> listLeases() throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean createLeaseIfNotExists(T var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public T getLease(String var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean renewLease(T var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean takeLease(T var1, String var2) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean evictLease(T var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public void deleteLease(T var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public void deleteAll() throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean updateLease(T var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean isLeaseTableEmpty() throws DependencyException, InvalidStateException, ProvisionedThroughputException;
}

