/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.Set;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.KinesisClientLibIOException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaseCleanupValidator;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.Log;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.LogFactory;

class KinesisLeaseCleanupValidator
implements LeaseCleanupValidator {
    private static final Log LOG = LogFactory.getLog(KinesisLeaseCleanupValidator.class);

    KinesisLeaseCleanupValidator() {
    }

    @Override
    public boolean isCandidateForCleanup(KinesisClientLease lease, Set<String> currentKinesisShardIds) throws KinesisClientLibIOException {
        boolean isCandidateForCleanup = true;
        if (currentKinesisShardIds.contains(lease.getLeaseKey())) {
            isCandidateForCleanup = false;
        } else {
            LOG.info("Found lease for non-existent shard: " + lease.getLeaseKey() + ". Checking its parent shards");
            Set<String> parentShardIds = lease.getParentShardIds();
            for (String parentShardId : parentShardIds) {
                if (!currentKinesisShardIds.contains(parentShardId)) continue;
                String message = "Parent shard " + parentShardId + " exists but not the child shard " + lease.getLeaseKey();
                LOG.info(message);
                throw new KinesisClientLibIOException(message);
            }
        }
        return isCandidateForCleanup;
    }
}

