/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;

@SdkInternalApi
public class AttributeValueMarshaller {
    private static final MarshallingInfo<String> S_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S").build();
    private static final MarshallingInfo<String> N_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("N").build();
    private static final MarshallingInfo<ByteBuffer> B_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("B").build();
    private static final MarshallingInfo<List> SS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SS").build();
    private static final MarshallingInfo<List> NS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NS").build();
    private static final MarshallingInfo<List> BS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BS").build();
    private static final MarshallingInfo<Map> M_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("M").build();
    private static final MarshallingInfo<List> L_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("L").build();
    private static final MarshallingInfo<Boolean> NULL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NULL").build();
    private static final MarshallingInfo<Boolean> BOOL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BOOL").build();
    private static final AttributeValueMarshaller instance = new AttributeValueMarshaller();

    public static AttributeValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(AttributeValue attributeValue, ProtocolMarshaller protocolMarshaller) {
        if (attributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(attributeValue.getS(), S_BINDING);
            protocolMarshaller.marshall(attributeValue.getN(), N_BINDING);
            protocolMarshaller.marshall(attributeValue.getB(), B_BINDING);
            protocolMarshaller.marshall(attributeValue.getSS(), SS_BINDING);
            protocolMarshaller.marshall(attributeValue.getNS(), NS_BINDING);
            protocolMarshaller.marshall(attributeValue.getBS(), BS_BINDING);
            protocolMarshaller.marshall(attributeValue.getM(), M_BINDING);
            protocolMarshaller.marshall(attributeValue.getL(), L_BINDING);
            protocolMarshaller.marshall(attributeValue.getNULL(), NULL_BINDING);
            protocolMarshaller.marshall(attributeValue.getBOOL(), BOOL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

