/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;

public class ExecuteStatementRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String statement;
    private List<AttributeValue> parameters;
    private Boolean consistentRead;
    private String nextToken;

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public String getStatement() {
        return this.statement;
    }

    public ExecuteStatementRequest withStatement(String statement) {
        this.setStatement(statement);
        return this;
    }

    public List<AttributeValue> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<AttributeValue> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<AttributeValue>(parameters);
    }

    public ExecuteStatementRequest withParameters(AttributeValue ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<AttributeValue>(parameters.length));
        }
        for (AttributeValue ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public ExecuteStatementRequest withParameters(Collection<AttributeValue> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public ExecuteStatementRequest withConsistentRead(Boolean consistentRead) {
        this.setConsistentRead(consistentRead);
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ExecuteStatementRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatement() != null) {
            sb.append("Statement: ").append(this.getStatement()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getConsistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.getConsistentRead()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest)obj;
        if (other.getStatement() == null ^ this.getStatement() == null) {
            return false;
        }
        if (other.getStatement() != null && !other.getStatement().equals(this.getStatement())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getConsistentRead() == null ^ this.getConsistentRead() == null) {
            return false;
        }
        if (other.getConsistentRead() != null && !other.getConsistentRead().equals(this.getConsistentRead())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatement() == null ? 0 : this.getStatement().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getConsistentRead() == null ? 0 : this.getConsistentRead().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ExecuteStatementRequest clone() {
        return (ExecuteStatementRequest)super.clone();
    }
}

