/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.TableCollection;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.ListTablesApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.ListTablesCollection;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.ListTablesSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ListTablesResult;

public class ListTablesImpl
implements ListTablesApi {
    private final AmazonDynamoDB client;

    public ListTablesImpl(AmazonDynamoDB client) {
        this.client = client;
    }

    @Override
    public TableCollection<ListTablesResult> listTables(ListTablesSpec spec) {
        return this.doList(spec);
    }

    @Override
    public TableCollection<ListTablesResult> listTables() {
        return this.doList(new ListTablesSpec());
    }

    @Override
    public TableCollection<ListTablesResult> listTables(String exclusiveStartTableName) {
        return this.doList(new ListTablesSpec().withExclusiveStartTableName(exclusiveStartTableName));
    }

    @Override
    public TableCollection<ListTablesResult> listTables(String exclusiveStartTableName, int maxResultSize) {
        return this.doList(new ListTablesSpec().withExclusiveStartTableName(exclusiveStartTableName).withMaxResultSize(maxResultSize));
    }

    @Override
    public TableCollection<ListTablesResult> listTables(int maxResultSize) {
        return this.doList(new ListTablesSpec().withMaxResultSize(maxResultSize));
    }

    private TableCollection<ListTablesResult> doList(ListTablesSpec spec) {
        return new ListTablesCollection(this.client, spec);
    }
}

