/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.DefaultRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.Request;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricDatum;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StatisticSet;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Marshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.StringUtils;

public class PutMetricDataRequestMarshaller
implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {
    @Override
    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {
        if (putMetricDataRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutMetricDataRequest> request = new DefaultRequest<PutMetricDataRequest>(putMetricDataRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricDataRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(putMetricDataRequest.getNamespace()));
        }
        if (!putMetricDataRequest.getMetricData().isEmpty() || !((SdkInternalList)putMetricDataRequest.getMetricData()).isAutoConstruct()) {
            SdkInternalList metricDataList = (SdkInternalList)putMetricDataRequest.getMetricData();
            int metricDataListIndex = 1;
            for (MetricDatum metricDataListValue : metricDataList) {
                if (metricDataListValue != null) {
                    StatisticSet statisticValues;
                    if (metricDataListValue.getMetricName() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".MetricName", StringUtils.fromString(metricDataListValue.getMetricName()));
                    }
                    if (!metricDataListValue.getDimensions().isEmpty() || !((SdkInternalList)metricDataListValue.getDimensions()).isAutoConstruct()) {
                        SdkInternalList dimensionsList = (SdkInternalList)metricDataListValue.getDimensions();
                        int dimensionsListIndex = 1;
                        for (Dimension dimensionsListValue : dimensionsList) {
                            if (dimensionsListValue != null) {
                                if (dimensionsListValue.getName() != null) {
                                    request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                                }
                                if (dimensionsListValue.getValue() != null) {
                                    request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                                }
                            }
                            ++dimensionsListIndex;
                        }
                    }
                    if (metricDataListValue.getTimestamp() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".Timestamp", StringUtils.fromDate(metricDataListValue.getTimestamp()));
                    }
                    if (metricDataListValue.getValue() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".Value", StringUtils.fromDouble(metricDataListValue.getValue()));
                    }
                    if ((statisticValues = metricDataListValue.getStatisticValues()) != null) {
                        if (statisticValues.getSampleCount() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.SampleCount", StringUtils.fromDouble(statisticValues.getSampleCount()));
                        }
                        if (statisticValues.getSum() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Sum", StringUtils.fromDouble(statisticValues.getSum()));
                        }
                        if (statisticValues.getMinimum() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Minimum", StringUtils.fromDouble(statisticValues.getMinimum()));
                        }
                        if (statisticValues.getMaximum() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Maximum", StringUtils.fromDouble(statisticValues.getMaximum()));
                        }
                    }
                    if (!metricDataListValue.getValues().isEmpty() || !((SdkInternalList)metricDataListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)metricDataListValue.getValues();
                        int valuesListIndex = 1;
                        for (Double valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("MetricData.member." + metricDataListIndex + ".Values.member." + valuesListIndex, StringUtils.fromDouble(valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                    if (!metricDataListValue.getCounts().isEmpty() || !((SdkInternalList)metricDataListValue.getCounts()).isAutoConstruct()) {
                        SdkInternalList countsList = (SdkInternalList)metricDataListValue.getCounts();
                        int countsListIndex = 1;
                        for (Double countsListValue : countsList) {
                            if (countsListValue != null) {
                                request.addParameter("MetricData.member." + metricDataListIndex + ".Counts.member." + countsListIndex, StringUtils.fromDouble(countsListValue));
                            }
                            ++countsListIndex;
                        }
                    }
                    if (metricDataListValue.getUnit() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".Unit", StringUtils.fromString(metricDataListValue.getUnit()));
                    }
                    if (metricDataListValue.getStorageResolution() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StorageResolution", StringUtils.fromInteger(metricDataListValue.getStorageResolution()));
                    }
                }
                ++metricDataListIndex;
            }
        }
        return request;
    }
}

