/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStreamFilter;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class MetricStreamFilterStaxUnmarshaller
implements Unmarshaller<MetricStreamFilter, StaxUnmarshallerContext> {
    private static MetricStreamFilterStaxUnmarshaller instance;

    @Override
    public MetricStreamFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricStreamFilter metricStreamFilter = new MetricStreamFilter();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return metricStreamFilter;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Namespace", targetDepth)) continue;
                metricStreamFilter.setNamespace(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return metricStreamFilter;
    }

    public static MetricStreamFilterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricStreamFilterStaxUnmarshaller();
        }
        return instance;
    }
}

