/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.DefaultRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.Request;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.GetMetricDataRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.LabelOptions;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Metric;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricDataQuery;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStat;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Marshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.StringUtils;

public class GetMetricDataRequestMarshaller
implements Marshaller<Request<GetMetricDataRequest>, GetMetricDataRequest> {
    @Override
    public Request<GetMetricDataRequest> marshall(GetMetricDataRequest getMetricDataRequest) {
        LabelOptions labelOptions;
        if (getMetricDataRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetMetricDataRequest> request = new DefaultRequest<GetMetricDataRequest>(getMetricDataRequest, "AmazonCloudWatch");
        request.addParameter("Action", "GetMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!getMetricDataRequest.getMetricDataQueries().isEmpty() || !((SdkInternalList)getMetricDataRequest.getMetricDataQueries()).isAutoConstruct()) {
            SdkInternalList metricDataQueriesList = (SdkInternalList)getMetricDataRequest.getMetricDataQueries();
            int metricDataQueriesListIndex = 1;
            for (MetricDataQuery metricDataQueriesListValue : metricDataQueriesList) {
                if (metricDataQueriesListValue != null) {
                    MetricStat metricStat;
                    if (metricDataQueriesListValue.getId() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Id", StringUtils.fromString(metricDataQueriesListValue.getId()));
                    }
                    if ((metricStat = metricDataQueriesListValue.getMetricStat()) != null) {
                        Metric metric = metricStat.getMetric();
                        if (metric != null) {
                            if (metric.getNamespace() != null) {
                                request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString(metric.getNamespace()));
                            }
                            if (metric.getMetricName() != null) {
                                request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString(metric.getMetricName()));
                            }
                            if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                                SdkInternalList dimensionsList = (SdkInternalList)metric.getDimensions();
                                int dimensionsListIndex = 1;
                                for (Dimension dimensionsListValue : dimensionsList) {
                                    if (dimensionsListValue != null) {
                                        if (dimensionsListValue.getName() != null) {
                                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                                        }
                                        if (dimensionsListValue.getValue() != null) {
                                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                                        }
                                    }
                                    ++dimensionsListIndex;
                                }
                            }
                        }
                        if (metricStat.getPeriod() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Period", StringUtils.fromInteger(metricStat.getPeriod()));
                        }
                        if (metricStat.getStat() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Stat", StringUtils.fromString(metricStat.getStat()));
                        }
                        if (metricStat.getUnit() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Unit", StringUtils.fromString(metricStat.getUnit()));
                        }
                    }
                    if (metricDataQueriesListValue.getExpression() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Expression", StringUtils.fromString(metricDataQueriesListValue.getExpression()));
                    }
                    if (metricDataQueriesListValue.getLabel() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Label", StringUtils.fromString(metricDataQueriesListValue.getLabel()));
                    }
                    if (metricDataQueriesListValue.getReturnData() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".ReturnData", StringUtils.fromBoolean(metricDataQueriesListValue.getReturnData()));
                    }
                    if (metricDataQueriesListValue.getPeriod() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Period", StringUtils.fromInteger(metricDataQueriesListValue.getPeriod()));
                    }
                }
                ++metricDataQueriesListIndex;
            }
        }
        if (getMetricDataRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(getMetricDataRequest.getStartTime()));
        }
        if (getMetricDataRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate(getMetricDataRequest.getEndTime()));
        }
        if (getMetricDataRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(getMetricDataRequest.getNextToken()));
        }
        if (getMetricDataRequest.getScanBy() != null) {
            request.addParameter("ScanBy", StringUtils.fromString(getMetricDataRequest.getScanBy()));
        }
        if (getMetricDataRequest.getMaxDatapoints() != null) {
            request.addParameter("MaxDatapoints", StringUtils.fromInteger(getMetricDataRequest.getMaxDatapoints()));
        }
        if ((labelOptions = getMetricDataRequest.getLabelOptions()) != null && labelOptions.getTimezone() != null) {
            request.addParameter("LabelOptions.Timezone", StringUtils.fromString(labelOptions.getTimezone()));
        }
        return request;
    }
}

