/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.DefaultRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.Request;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Marshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.StringUtils;

public class DescribeAlarmHistoryRequestMarshaller
implements Marshaller<Request<DescribeAlarmHistoryRequest>, DescribeAlarmHistoryRequest> {
    @Override
    public Request<DescribeAlarmHistoryRequest> marshall(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        if (describeAlarmHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAlarmHistoryRequest> request = new DefaultRequest<DescribeAlarmHistoryRequest>(describeAlarmHistoryRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAlarmHistory");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAlarmHistoryRequest.getAlarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString(describeAlarmHistoryRequest.getAlarmName()));
        }
        if (!describeAlarmHistoryRequest.getAlarmTypes().isEmpty() || !((SdkInternalList)describeAlarmHistoryRequest.getAlarmTypes()).isAutoConstruct()) {
            SdkInternalList alarmTypesList = (SdkInternalList)describeAlarmHistoryRequest.getAlarmTypes();
            int alarmTypesListIndex = 1;
            for (String alarmTypesListValue : alarmTypesList) {
                if (alarmTypesListValue != null) {
                    request.addParameter("AlarmTypes.member." + alarmTypesListIndex, StringUtils.fromString(alarmTypesListValue));
                }
                ++alarmTypesListIndex;
            }
        }
        if (describeAlarmHistoryRequest.getHistoryItemType() != null) {
            request.addParameter("HistoryItemType", StringUtils.fromString(describeAlarmHistoryRequest.getHistoryItemType()));
        }
        if (describeAlarmHistoryRequest.getStartDate() != null) {
            request.addParameter("StartDate", StringUtils.fromDate(describeAlarmHistoryRequest.getStartDate()));
        }
        if (describeAlarmHistoryRequest.getEndDate() != null) {
            request.addParameter("EndDate", StringUtils.fromDate(describeAlarmHistoryRequest.getEndDate()));
        }
        if (describeAlarmHistoryRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeAlarmHistoryRequest.getMaxRecords()));
        }
        if (describeAlarmHistoryRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeAlarmHistoryRequest.getNextToken()));
        }
        if (describeAlarmHistoryRequest.getScanBy() != null) {
            request.addParameter("ScanBy", StringUtils.fromString(describeAlarmHistoryRequest.getScanBy()));
        }
        return request;
    }
}

