/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.AnomalyDetector;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform.AnomalyDetectorConfigurationStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform.DimensionStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class AnomalyDetectorStaxUnmarshaller
implements Unmarshaller<AnomalyDetector, StaxUnmarshallerContext> {
    private static AnomalyDetectorStaxUnmarshaller instance;

    @Override
    public AnomalyDetector unmarshall(StaxUnmarshallerContext context) throws Exception {
        AnomalyDetector anomalyDetector = new AnomalyDetector();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return anomalyDetector;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Namespace", targetDepth)) {
                    anomalyDetector.setNamespace(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricName", targetDepth)) {
                    anomalyDetector.setMetricName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    anomalyDetector.withDimensions(new ArrayList<Dimension>());
                    continue;
                }
                if (context.testExpression("Dimensions/member", targetDepth)) {
                    anomalyDetector.withDimensions(DimensionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Stat", targetDepth)) {
                    anomalyDetector.setStat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Configuration", targetDepth)) {
                    anomalyDetector.setConfiguration(AnomalyDetectorConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StateValue", targetDepth)) continue;
                anomalyDetector.setStateValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return anomalyDetector;
    }

    public static AnomalyDetectorStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AnomalyDetectorStaxUnmarshaller();
        }
        return instance;
    }
}

