/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StandardUnit;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StatisticSet;

public class MetricDatum
implements Serializable,
Cloneable {
    private String metricName;
    private SdkInternalList<Dimension> dimensions;
    private Date timestamp;
    private Double value;
    private StatisticSet statisticValues;
    private SdkInternalList<Double> values;
    private SdkInternalList<Double> counts;
    private String unit;
    private Integer storageResolution;

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public MetricDatum withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new SdkInternalList();
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new SdkInternalList<Dimension>(dimensions);
    }

    public MetricDatum withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new SdkInternalList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public MetricDatum withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public MetricDatum withTimestamp(Date timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Double getValue() {
        return this.value;
    }

    public MetricDatum withValue(Double value) {
        this.setValue(value);
        return this;
    }

    public void setStatisticValues(StatisticSet statisticValues) {
        this.statisticValues = statisticValues;
    }

    public StatisticSet getStatisticValues() {
        return this.statisticValues;
    }

    public MetricDatum withStatisticValues(StatisticSet statisticValues) {
        this.setStatisticValues(statisticValues);
        return this;
    }

    public List<Double> getValues() {
        if (this.values == null) {
            this.values = new SdkInternalList();
        }
        return this.values;
    }

    public void setValues(Collection<Double> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new SdkInternalList<Double>(values);
    }

    public MetricDatum withValues(Double ... values) {
        if (this.values == null) {
            this.setValues(new SdkInternalList<Double>(values.length));
        }
        for (Double ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public MetricDatum withValues(Collection<Double> values) {
        this.setValues(values);
        return this;
    }

    public List<Double> getCounts() {
        if (this.counts == null) {
            this.counts = new SdkInternalList();
        }
        return this.counts;
    }

    public void setCounts(Collection<Double> counts) {
        if (counts == null) {
            this.counts = null;
            return;
        }
        this.counts = new SdkInternalList<Double>(counts);
    }

    public MetricDatum withCounts(Double ... counts) {
        if (this.counts == null) {
            this.setCounts(new SdkInternalList<Double>(counts.length));
        }
        for (Double ele : counts) {
            this.counts.add(ele);
        }
        return this;
    }

    public MetricDatum withCounts(Collection<Double> counts) {
        this.setCounts(counts);
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public MetricDatum withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public void setUnit(StandardUnit unit) {
        this.withUnit(unit);
    }

    public MetricDatum withUnit(StandardUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    public void setStorageResolution(Integer storageResolution) {
        this.storageResolution = storageResolution;
    }

    public Integer getStorageResolution() {
        return this.storageResolution;
    }

    public MetricDatum withStorageResolution(Integer storageResolution) {
        this.setStorageResolution(storageResolution);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getStatisticValues() != null) {
            sb.append("StatisticValues: ").append(this.getStatisticValues()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues()).append(",");
        }
        if (this.getCounts() != null) {
            sb.append("Counts: ").append(this.getCounts()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit()).append(",");
        }
        if (this.getStorageResolution() != null) {
            sb.append("StorageResolution: ").append(this.getStorageResolution());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatum)) {
            return false;
        }
        MetricDatum other = (MetricDatum)obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        if (other.getTimestamp() != null && !other.getTimestamp().equals(this.getTimestamp())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getStatisticValues() == null ^ this.getStatisticValues() == null) {
            return false;
        }
        if (other.getStatisticValues() != null && !other.getStatisticValues().equals(this.getStatisticValues())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        if (other.getValues() != null && !other.getValues().equals(this.getValues())) {
            return false;
        }
        if (other.getCounts() == null ^ this.getCounts() == null) {
            return false;
        }
        if (other.getCounts() != null && !other.getCounts().equals(this.getCounts())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        if (other.getUnit() != null && !other.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (other.getStorageResolution() == null ^ this.getStorageResolution() == null) {
            return false;
        }
        return other.getStorageResolution() == null || other.getStorageResolution().equals(this.getStorageResolution());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getStatisticValues() == null ? 0 : this.getStatisticValues().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        hashCode = 31 * hashCode + (this.getCounts() == null ? 0 : this.getCounts().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        hashCode = 31 * hashCode + (this.getStorageResolution() == null ? 0 : this.getStorageResolution().hashCode());
        return hashCode;
    }

    public MetricDatum clone() {
        try {
            return (MetricDatum)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

