/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.AnomalyDetectorConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.AnomalyDetectorStateValue;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;

public class AnomalyDetector
implements Serializable,
Cloneable {
    private String namespace;
    private String metricName;
    private SdkInternalList<Dimension> dimensions;
    private String stat;
    private AnomalyDetectorConfiguration configuration;
    private String stateValue;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public AnomalyDetector withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public AnomalyDetector withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new SdkInternalList();
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new SdkInternalList<Dimension>(dimensions);
    }

    public AnomalyDetector withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new SdkInternalList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public AnomalyDetector withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public String getStat() {
        return this.stat;
    }

    public AnomalyDetector withStat(String stat) {
        this.setStat(stat);
        return this;
    }

    public void setConfiguration(AnomalyDetectorConfiguration configuration) {
        this.configuration = configuration;
    }

    public AnomalyDetectorConfiguration getConfiguration() {
        return this.configuration;
    }

    public AnomalyDetector withConfiguration(AnomalyDetectorConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setStateValue(String stateValue) {
        this.stateValue = stateValue;
    }

    public String getStateValue() {
        return this.stateValue;
    }

    public AnomalyDetector withStateValue(String stateValue) {
        this.setStateValue(stateValue);
        return this;
    }

    public AnomalyDetector withStateValue(AnomalyDetectorStateValue stateValue) {
        this.stateValue = stateValue.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getStat() != null) {
            sb.append("Stat: ").append(this.getStat()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getStateValue() != null) {
            sb.append("StateValue: ").append(this.getStateValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetector)) {
            return false;
        }
        AnomalyDetector other = (AnomalyDetector)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getStat() == null ^ this.getStat() == null) {
            return false;
        }
        if (other.getStat() != null && !other.getStat().equals(this.getStat())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getStateValue() == null ^ this.getStateValue() == null) {
            return false;
        }
        return other.getStateValue() == null || other.getStateValue().equals(this.getStateValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getStat() == null ? 0 : this.getStat().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getStateValue() == null ? 0 : this.getStateValue().hashCode());
        return hashCode;
    }

    public AnomalyDetector clone() {
        try {
            return (AnomalyDetector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

