/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.retry;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkBaseException;

public class RetryUtils {
    static final Set<String> THROTTLING_ERROR_CODES = new HashSet<String>(9);
    static final Set<String> CLOCK_SKEW_ERROR_CODES = new HashSet<String>(6);
    static final Set<String> RETRYABLE_ERROR_CODES = new HashSet<String>(1);
    static final Set<Integer> RETRYABLE_STATUS_CODES = new HashSet<Integer>(4);

    public static boolean isRetryableServiceException(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && RetryUtils.isRetryableServiceException(RetryUtils.toAse(exception));
    }

    public static boolean isRetryableServiceException(AmazonServiceException exception) {
        return RETRYABLE_STATUS_CODES.contains(exception.getStatusCode()) || RETRYABLE_ERROR_CODES.contains(exception.getErrorCode());
    }

    public static boolean isThrottlingException(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && RetryUtils.isThrottlingException(RetryUtils.toAse(exception));
    }

    public static boolean isThrottlingException(AmazonServiceException exception) {
        return THROTTLING_ERROR_CODES.contains(exception.getErrorCode()) || exception.getStatusCode() == 429;
    }

    public static boolean isRequestEntityTooLargeException(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && RetryUtils.isRequestEntityTooLargeException(RetryUtils.toAse(exception));
    }

    public static boolean isRequestEntityTooLargeException(AmazonServiceException exception) {
        return exception.getStatusCode() == 413;
    }

    public static boolean isClockSkewError(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && RetryUtils.isClockSkewError(RetryUtils.toAse(exception));
    }

    public static boolean isClockSkewError(AmazonServiceException exception) {
        return CLOCK_SKEW_ERROR_CODES.contains(exception.getErrorCode());
    }

    private static boolean isAse(SdkBaseException e) {
        return e instanceof AmazonServiceException;
    }

    private static AmazonServiceException toAse(SdkBaseException e) {
        return (AmazonServiceException)e;
    }

    static {
        THROTTLING_ERROR_CODES.add("Throttling");
        THROTTLING_ERROR_CODES.add("ThrottlingException");
        THROTTLING_ERROR_CODES.add("ThrottledException");
        THROTTLING_ERROR_CODES.add("ProvisionedThroughputExceededException");
        THROTTLING_ERROR_CODES.add("SlowDown");
        THROTTLING_ERROR_CODES.add("TooManyRequestsException");
        THROTTLING_ERROR_CODES.add("RequestLimitExceeded");
        THROTTLING_ERROR_CODES.add("BandwidthLimitExceeded");
        THROTTLING_ERROR_CODES.add("RequestThrottled");
        THROTTLING_ERROR_CODES.add("RequestThrottledException");
        THROTTLING_ERROR_CODES.add("EC2ThrottledException");
        THROTTLING_ERROR_CODES.add("PriorRequestNotComplete");
        CLOCK_SKEW_ERROR_CODES.add("RequestTimeTooSkewed");
        CLOCK_SKEW_ERROR_CODES.add("RequestExpired");
        CLOCK_SKEW_ERROR_CODES.add("InvalidSignatureException");
        CLOCK_SKEW_ERROR_CODES.add("SignatureDoesNotMatch");
        CLOCK_SKEW_ERROR_CODES.add("AuthFailure");
        CLOCK_SKEW_ERROR_CODES.add("RequestInTheFuture");
        RETRYABLE_ERROR_CODES.add("TransactionInProgressException");
        RETRYABLE_ERROR_CODES.add("RequestTimeout");
        RETRYABLE_ERROR_CODES.add("RequestTimeoutException");
        RETRYABLE_ERROR_CODES.add("IDPCommunicationError");
        RETRYABLE_STATUS_CODES.add(500);
        RETRYABLE_STATUS_CODES.add(502);
        RETRYABLE_STATUS_CODES.add(503);
        RETRYABLE_STATUS_CODES.add(504);
    }
}

