/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.util;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;

@PublicEvolving
public abstract class WatermarkTracker
implements Closeable,
Serializable {
    public static final long DEFAULT_UPDATE_TIMEOUT_MILLIS = 60000L;
    private long updateTimeoutMillis = 60000L;
    private String subtaskId;

    protected String getSubtaskId() {
        return this.subtaskId;
    }

    protected long getUpdateTimeoutMillis() {
        return this.updateTimeoutMillis;
    }

    public abstract long getUpdateTimeoutCount();

    public void setUpdateTimeoutMillis(long updateTimeoutMillis) {
        this.updateTimeoutMillis = updateTimeoutMillis;
    }

    public abstract long updateWatermark(long var1);

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public void open(RuntimeContext context) {
        this.subtaskId = context instanceof StreamingRuntimeContext ? ((StreamingRuntimeContext)context).getOperatorUniqueID() + "-" + context.getIndexOfThisSubtask() : context.getTaskNameWithSubtasks();
    }

    @Override
    public void close() {
    }

    protected static class WatermarkState {
        protected long watermark = Long.MIN_VALUE;
        protected long lastUpdated;

        protected WatermarkState() {
        }

        public long getWatermark() {
            return this.watermark;
        }

        public String toString() {
            return "WatermarkState{watermark=" + this.watermark + ", lastUpdated=" + this.lastUpdated + '}';
        }
    }
}

