/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.util;

import java.net.URI;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.Protocol;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.Http2Configuration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.profiles.ProfileFile;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import org.apache.flink.streaming.connectors.kinesis.config.AWSConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.config.ConsumerConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.util.AWSUtil;

@Internal
public class AwsV2Util {
    private static final int INITIAL_WINDOW_SIZE_BYTES = 524288;
    private static final Duration HEALTH_CHECK_PING_PERIOD = Duration.ofSeconds(60L);
    private static final Duration CONNECTION_ACQUISITION_TIMEOUT = Duration.ofSeconds(60L);

    public static KinesisAsyncClient createKinesisAsyncClient(Properties configProps, ClientConfiguration clientConfiguration, SdkAsyncHttpClient httpClient) {
        ClientOverrideConfiguration overrideConfiguration = AwsV2Util.createClientOverrideConfiguration(clientConfiguration, ClientOverrideConfiguration.builder());
        KinesisAsyncClientBuilder clientBuilder = KinesisAsyncClient.builder();
        return AwsV2Util.createKinesisAsyncClient(configProps, clientBuilder, httpClient, overrideConfiguration);
    }

    public static SdkAsyncHttpClient createHttpClient(ClientConfiguration config, NettyNioAsyncHttpClient.Builder httpClientBuilder, Properties consumerConfig) {
        int maxConcurrency = Optional.ofNullable(consumerConfig.getProperty("flink.stream.efo.http-client.max-concurrency")).map(Integer::parseInt).orElse(10000);
        httpClientBuilder.maxConcurrency(maxConcurrency).connectionTimeout(Duration.ofMillis(config.getConnectionTimeout())).writeTimeout(Duration.ofMillis(config.getSocketTimeout())).connectionMaxIdleTime(Duration.ofMillis(config.getConnectionMaxIdleMillis())).useIdleConnectionReaper(config.useReaper()).protocol(Protocol.HTTP2).connectionAcquisitionTimeout(CONNECTION_ACQUISITION_TIMEOUT).http2Configuration((Http2Configuration)Http2Configuration.builder().healthCheckPingPeriod(HEALTH_CHECK_PING_PERIOD).initialWindowSize(524288).build());
        if (config.getConnectionTTL() > -1L) {
            httpClientBuilder.connectionTimeToLive(Duration.ofMillis(config.getConnectionTTL()));
        }
        return httpClientBuilder.build();
    }

    @VisibleForTesting
    static ClientOverrideConfiguration createClientOverrideConfiguration(ClientConfiguration config, ClientOverrideConfiguration.Builder overrideConfigurationBuilder) {
        overrideConfigurationBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, AWSUtil.formatFlinkUserAgentPrefix()).putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, config.getUserAgentSuffix());
        if (config.getRequestTimeout() > 0) {
            overrideConfigurationBuilder.apiCallAttemptTimeout(Duration.ofMillis(config.getRequestTimeout()));
        }
        if (config.getClientExecutionTimeout() > 0) {
            overrideConfigurationBuilder.apiCallTimeout(Duration.ofMillis(config.getClientExecutionTimeout()));
        }
        return (ClientOverrideConfiguration)overrideConfigurationBuilder.build();
    }

    @VisibleForTesting
    static KinesisAsyncClient createKinesisAsyncClient(Properties configProps, KinesisAsyncClientBuilder clientBuilder, SdkAsyncHttpClient httpClient, ClientOverrideConfiguration overrideConfiguration) {
        if (configProps.containsKey("aws.endpoint")) {
            URI endpointOverride = URI.create(configProps.getProperty("aws.endpoint"));
            clientBuilder.endpointOverride(endpointOverride);
        }
        return (KinesisAsyncClient)((KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)clientBuilder.httpClient(httpClient)).overrideConfiguration(overrideConfiguration)).credentialsProvider(AwsV2Util.getCredentialsProvider(configProps))).region(AwsV2Util.getRegion(configProps))).build();
    }

    public static AwsCredentialsProvider getCredentialsProvider(Properties configProps) {
        return AwsV2Util.getCredentialsProvider(configProps, "aws.credentials.provider");
    }

    private static AwsCredentialsProvider getCredentialsProvider(Properties configProps, String configPrefix) {
        AWSConfigConstants.CredentialProvider credentialProviderType = AWSUtil.getCredentialProviderType(configProps, configPrefix);
        switch (credentialProviderType) {
            case ENV_VAR: {
                return EnvironmentVariableCredentialsProvider.create();
            }
            case SYS_PROP: {
                return SystemPropertyCredentialsProvider.create();
            }
            case PROFILE: {
                return AwsV2Util.getProfileCredentialProvider(configProps, configPrefix);
            }
            case BASIC: {
                return () -> AwsBasicCredentials.create(configProps.getProperty(AWSConfigConstants.accessKeyId(configPrefix)), configProps.getProperty(AWSConfigConstants.secretKey(configPrefix)));
            }
            case ASSUME_ROLE: {
                return AwsV2Util.getAssumeRoleCredentialProvider(configProps, configPrefix);
            }
            case WEB_IDENTITY_TOKEN: {
                return AwsV2Util.getWebIdentityTokenFileCredentialsProvider(WebIdentityTokenFileCredentialsProvider.builder(), configProps, configPrefix);
            }
            case AUTO: {
                return DefaultCredentialsProvider.create();
            }
        }
        throw new IllegalArgumentException("Credential provider not supported: " + (Object)((Object)credentialProviderType));
    }

    private static AwsCredentialsProvider getProfileCredentialProvider(Properties configProps, String configPrefix) {
        String profileName = configProps.getProperty(AWSConfigConstants.profileName(configPrefix), null);
        String profileConfigPath = configProps.getProperty(AWSConfigConstants.profilePath(configPrefix), null);
        ProfileCredentialsProvider.Builder profileBuilder = ProfileCredentialsProvider.builder().profileName(profileName);
        if (profileConfigPath != null) {
            profileBuilder.profileFile(ProfileFile.builder().type(ProfileFile.Type.CREDENTIALS).content(Paths.get(profileConfigPath, new String[0])).build());
        }
        return profileBuilder.build();
    }

    private static AwsCredentialsProvider getAssumeRoleCredentialProvider(Properties configProps, String configPrefix) {
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix))).roleSessionName(configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix))).externalId(configProps.getProperty(AWSConfigConstants.externalId(configPrefix))).build()).stsClient((StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(AwsV2Util.getCredentialsProvider(configProps, AWSConfigConstants.roleCredentialsProvider(configPrefix)))).region(AwsV2Util.getRegion(configProps))).build())).build();
    }

    @VisibleForTesting
    static AwsCredentialsProvider getWebIdentityTokenFileCredentialsProvider(WebIdentityTokenFileCredentialsProvider.Builder webIdentityBuilder, Properties configProps, String configPrefix) {
        webIdentityBuilder.roleArn(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix), null)).roleSessionName(configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix), null));
        Optional.ofNullable(configProps.getProperty(AWSConfigConstants.webIdentityTokenFile(configPrefix), null)).map(x$0 -> Paths.get(x$0, new String[0])).ifPresent(webIdentityBuilder::webIdentityTokenFile);
        return webIdentityBuilder.build();
    }

    public static Region getRegion(Properties configProps) {
        return Region.of(configProps.getProperty("aws.region"));
    }

    public static boolean isRecoverableException(Exception e) {
        Throwable cause = e.getCause();
        return cause instanceof LimitExceededException || cause instanceof ProvisionedThroughputExceededException;
    }

    public static boolean isUsingEfoRecordPublisher(Properties properties) {
        return ConsumerConfigConstants.RecordPublisherType.EFO.name().equals(properties.get("flink.stream.recordpublisher"));
    }

    public static boolean isEagerEfoRegistrationType(Properties properties) {
        return ConsumerConfigConstants.EFORegistrationType.EAGER.name().equals(properties.get("flink.stream.efo.registration"));
    }

    public static boolean isLazyEfoRegistrationType(Properties properties) {
        return !AwsV2Util.isEagerEfoRegistrationType(properties) && !AwsV2Util.isNoneEfoRegistrationType(properties);
    }

    public static boolean isNoneEfoRegistrationType(Properties properties) {
        return ConsumerConfigConstants.EFORegistrationType.NONE.name().equals(properties.get("flink.stream.efo.registration"));
    }
}

