/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.kinesis.table.KinesisDynamicSink;
import org.apache.flink.streaming.connectors.kinesis.table.KinesisDynamicSource;
import org.apache.flink.streaming.connectors.kinesis.table.KinesisOptions;
import org.apache.flink.streaming.connectors.kinesis.util.KinesisConfigUtil;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class KinesisDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "kinesis";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        ResolvedCatalogTable catalogTable = context.getCatalogTable();
        Properties properties = KinesisOptions.getConsumerProperties(catalogTable.getOptions());
        DecodingFormat decodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT);
        helper.validateExcept(KinesisOptions.NON_VALIDATED_PREFIXES);
        KinesisDynamicTableFactory.validateConsumerProperties((String)tableOptions.get(KinesisOptions.STREAM), properties);
        DataType physicalDataType = catalogTable.getResolvedSchema().toPhysicalRowDataType();
        return new KinesisDynamicSource(physicalDataType, (String)tableOptions.get(KinesisOptions.STREAM), properties, (DecodingFormat<DeserializationSchema<RowData>>)decodingFormat);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        ResolvedCatalogTable catalogTable = context.getCatalogTable();
        Properties properties = KinesisOptions.getProducerProperties(catalogTable.getOptions());
        EncodingFormat encodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT);
        helper.validateExcept(KinesisOptions.NON_VALIDATED_PREFIXES);
        KinesisDynamicTableFactory.validateKinesisPartitioner(tableOptions, (CatalogTable)catalogTable);
        KinesisDynamicTableFactory.validateProducerProperties(properties);
        DataType physicalDataType = catalogTable.getResolvedSchema().toPhysicalRowDataType();
        return new KinesisDynamicSink(physicalDataType, (String)tableOptions.get(KinesisOptions.STREAM), properties, (EncodingFormat<SerializationSchema<RowData>>)encodingFormat, KinesisOptions.getKinesisPartitioner(tableOptions, (RowType)physicalDataType.getLogicalType(), catalogTable.getPartitionKeys(), context.getClassLoader()));
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KinesisOptions.STREAM);
        options.add(FactoryUtil.FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(KinesisOptions.SINK_PARTITIONER);
        options.add(KinesisOptions.SINK_PARTITIONER_FIELD_DELIMITER);
        return options;
    }

    private static void validateConsumerProperties(String stream, Properties properties) {
        List<String> streams = Collections.singletonList(stream);
        KinesisConfigUtil.validateConsumerConfiguration(properties, streams);
    }

    private static void validateProducerProperties(Properties properties) {
        KinesisConfigUtil.getValidatedProducerConfiguration(properties);
    }

    public static void validateKinesisPartitioner(ReadableConfig tableOptions, CatalogTable targetTable) {
        tableOptions.getOptional(KinesisOptions.SINK_PARTITIONER).ifPresent(partitioner -> {
            if (targetTable.isPartitioned()) {
                throw new ValidationException(String.format("Cannot set %s option for a table defined with a PARTITIONED BY clause", KinesisOptions.SINK_PARTITIONER.key()));
            }
        });
    }
}

