/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.connectors.kinesis.FlinkKinesisProducer;
import org.apache.flink.streaming.connectors.kinesis.KinesisPartitioner;
import org.apache.flink.streaming.connectors.kinesis.table.RowDataFieldsKinesisPartitioner;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Internal
public class KinesisDynamicSink
implements DynamicTableSink,
SupportsPartitioning {
    private final DataType consumedDataType;
    private final String stream;
    private final Properties producerProperties;
    private final EncodingFormat<SerializationSchema<RowData>> encodingFormat;
    private final KinesisPartitioner<RowData> partitioner;

    public KinesisDynamicSink(DataType consumedDataType, String stream, Properties producerProperties, EncodingFormat<SerializationSchema<RowData>> encodingFormat, KinesisPartitioner<RowData> partitioner) {
        this.consumedDataType = (DataType)Preconditions.checkNotNull((Object)consumedDataType, (String)"Consumed data type must not be null");
        this.stream = (String)Preconditions.checkNotNull((Object)stream, (String)"Kinesis stream name must not be null");
        this.producerProperties = (Properties)Preconditions.checkNotNull((Object)producerProperties, (String)"Properties for the Flink Kinesis producer must not be null");
        this.encodingFormat = (EncodingFormat)Preconditions.checkNotNull(encodingFormat, (String)"Encoding format must not be null");
        this.partitioner = (KinesisPartitioner)Preconditions.checkNotNull(partitioner, (String)"Kinesis partitioner must not be null");
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return this.encodingFormat.getChangelogMode();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SerializationSchema serializationSchema = (SerializationSchema)this.encodingFormat.createRuntimeEncoder(context, this.consumedDataType);
        FlinkKinesisProducer<RowData> kinesisProducer = new FlinkKinesisProducer<RowData>(serializationSchema, this.producerProperties);
        kinesisProducer.setDefaultStream(this.stream);
        kinesisProducer.setCustomPartitioner(this.partitioner);
        return SinkFunctionProvider.of(kinesisProducer);
    }

    public DynamicTableSink copy() {
        return new KinesisDynamicSink(this.consumedDataType, this.stream, this.producerProperties, this.encodingFormat, this.partitioner);
    }

    public String asSummaryString() {
        return "Kinesis";
    }

    public void applyStaticPartition(Map<String, String> partition) {
        if (!(this.partitioner instanceof RowDataFieldsKinesisPartitioner)) {
            String msg = "Cannot apply static partition optimization to a partition class that does not inherit from org.apache.flink.streaming.connectors.kinesis.table.RowDataKinesisPartitioner.";
            throw new RuntimeException(msg);
        }
        ((RowDataFieldsKinesisPartitioner)this.partitioner).setStaticFields(partition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KinesisDynamicSink that = (KinesisDynamicSink)o;
        return Objects.equals(this.consumedDataType, that.consumedDataType) && Objects.equals(this.stream, that.stream) && Objects.equals(this.producerProperties, that.producerProperties) && Objects.equals(this.encodingFormat, that.encodingFormat) && Objects.equals(this.partitioner, that.partitioner);
    }

    public int hashCode() {
        return Objects.hash(this.consumedDataType, this.stream, this.producerProperties, this.encodingFormat, this.partitioner);
    }
}

