/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.WebIdentityTokenCredentialsProviderFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.internal.WebIdentityTokenCredentialProperties;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.retry.RetryPolicyContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.retry.conditions.RetryCondition;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.IdpCommunicationErrorException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkProtectedApi
public final class StsWebIdentityCredentialsProviderFactory
implements WebIdentityTokenCredentialsProviderFactory {
    @Override
    public AwsCredentialsProvider create(WebIdentityTokenCredentialProperties credentialProperties) {
        return new StsWebIdentityCredentialsProvider(credentialProperties);
    }

    private static final class StsRetryCondition
    implements RetryCondition {
        private StsRetryCondition() {
        }

        @Override
        public boolean shouldRetry(RetryPolicyContext context) {
            return context.exception() instanceof IdpCommunicationErrorException;
        }
    }

    private static final class AssumeRoleWithWebIdentityRequestSupplier
    implements Supplier {
        private final AssumeRoleWithWebIdentityRequest request;
        private final Path webIdentityTokenFile;

        AssumeRoleWithWebIdentityRequestSupplier(AssumeRoleWithWebIdentityRequest request, Path webIdentityTokenFile) {
            this.request = request;
            this.webIdentityTokenFile = webIdentityTokenFile;
        }

        public Object get() {
            return this.request.toBuilder().webIdentityToken(this.getToken(this.webIdentityTokenFile)).build();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getToken(Path file) {
            try (InputStream webIdentityTokenStream = Files.newInputStream(file, new OpenOption[0]);){
                String string = IoUtils.toUtf8String(webIdentityTokenStream);
                return string;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static final class StsWebIdentityCredentialsProvider
    implements AwsCredentialsProvider,
    SdkAutoCloseable {
        private final StsClient stsClient;
        private final StsAssumeRoleWithWebIdentityCredentialsProvider credentialsProvider;

        private StsWebIdentityCredentialsProvider(WebIdentityTokenCredentialProperties credentialProperties) {
            String roleSessionName = credentialProperties.roleSessionName();
            String sessionName = roleSessionName != null ? roleSessionName : "aws-sdk-java-" + System.currentTimeMillis();
            OrRetryCondition retryCondition = OrRetryCondition.create(new StsRetryCondition(), RetryCondition.defaultRetryCondition());
            this.stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().applyMutation(this::configureEndpoint).credentialsProvider(AnonymousCredentialsProvider.create())).overrideConfiguration(o -> o.retryPolicy(r -> r.retryCondition(retryCondition)))).build();
            AssumeRoleWithWebIdentityRequest request = (AssumeRoleWithWebIdentityRequest)AssumeRoleWithWebIdentityRequest.builder().roleArn(credentialProperties.roleArn()).roleSessionName(sessionName).build();
            AssumeRoleWithWebIdentityRequestSupplier supplier = new AssumeRoleWithWebIdentityRequestSupplier(request, credentialProperties.webIdentityTokenFile());
            this.credentialsProvider = ((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().stsClient(this.stsClient)).refreshRequest(supplier).build();
        }

        @Override
        public AwsCredentials resolveCredentials() {
            return this.credentialsProvider.resolveCredentials();
        }

        @Override
        public void close() {
            IoUtils.closeQuietly(this.credentialsProvider, null);
            IoUtils.closeQuietly(this.stsClient, null);
        }

        private void configureEndpoint(StsClientBuilder stsClientBuilder) {
            Region stsRegion;
            try {
                stsRegion = new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (RuntimeException e) {
                stsRegion = null;
            }
            if (stsRegion != null) {
                stsClientBuilder.region(stsRegion);
            } else {
                stsClientBuilder.region(Region.US_EAST_1);
                stsClientBuilder.endpointOverride(URI.create("https://sts.amazonaws.com"));
            }
        }
    }
}

