/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.NotThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth.SessionCredentialsHolder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.Credentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.cache.CachedSupplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.cache.NonBlocking;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.cache.RefreshResult;

@ThreadSafe
@SdkInternalApi
abstract class StsCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private static final Duration DEFAULT_STALE_TIME = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_PREFETCH_TIME = Duration.ofMinutes(5L);
    private final StsClient stsClient;
    private final CachedSupplier<SessionCredentialsHolder> sessionCache;
    private final Duration staleTime;
    private final Duration prefetchTime;

    protected StsCredentialsProvider(BaseBuilder<?, ?> builder, String asyncThreadName) {
        this.stsClient = Validate.notNull(((BaseBuilder)builder).stsClient, "STS client must not be null.", new Object[0]);
        this.staleTime = Optional.ofNullable(((BaseBuilder)builder).staleTime).orElse(DEFAULT_STALE_TIME);
        this.prefetchTime = Optional.ofNullable(((BaseBuilder)builder).prefetchTime).orElse(DEFAULT_PREFETCH_TIME);
        CachedSupplier.Builder cacheBuilder = CachedSupplier.builder(this::updateSessionCredentials);
        if (((BaseBuilder)builder).asyncCredentialUpdateEnabled.booleanValue()) {
            cacheBuilder.prefetchStrategy(new NonBlocking(asyncThreadName));
        }
        this.sessionCache = cacheBuilder.build();
    }

    private RefreshResult<SessionCredentialsHolder> updateSessionCredentials() {
        SessionCredentialsHolder credentials = new SessionCredentialsHolder(this.getUpdatedCredentials(this.stsClient));
        Instant actualTokenExpiration = credentials.getSessionCredentialsExpiration().toInstant();
        return RefreshResult.builder(credentials).staleTime(actualTokenExpiration.minus(this.staleTime)).prefetchTime(actualTokenExpiration.minus(this.prefetchTime)).build();
    }

    @Override
    public AwsCredentials resolveCredentials() {
        return this.sessionCache.get().getSessionCredentials();
    }

    @Override
    public void close() {
        this.sessionCache.close();
    }

    public Duration staleTime() {
        return this.staleTime;
    }

    public Duration prefetchTime() {
        return this.prefetchTime;
    }

    protected abstract Credentials getUpdatedCredentials(StsClient var1);

    @NotThreadSafe
    protected static abstract class BaseBuilder<B extends BaseBuilder<B, T>, T> {
        private final Function<B, T> providerConstructor;
        private Boolean asyncCredentialUpdateEnabled = false;
        private StsClient stsClient;
        private Duration staleTime;
        private Duration prefetchTime;

        protected BaseBuilder(Function<B, T> providerConstructor) {
            this.providerConstructor = providerConstructor;
        }

        public B stsClient(StsClient stsClient) {
            this.stsClient = stsClient;
            return (B)this;
        }

        public B asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return (B)this;
        }

        public B staleTime(Duration staleTime) {
            this.staleTime = staleTime;
            return (B)this;
        }

        public B prefetchTime(Duration prefetchTime) {
            this.prefetchTime = prefetchTime;
            return (B)this;
        }

        public T build() {
            return this.providerConstructor.apply(this);
        }
    }
}

