/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkBytes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordsRequestEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PutRecordsRequestEntry> {
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.builder(MarshallingType.SDK_BYTES).memberName("Data").getter(PutRecordsRequestEntry.getter(PutRecordsRequestEntry::data)).setter(PutRecordsRequestEntry.setter(Builder::data)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();
    private static final SdkField<String> EXPLICIT_HASH_KEY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ExplicitHashKey").getter(PutRecordsRequestEntry.getter(PutRecordsRequestEntry::explicitHashKey)).setter(PutRecordsRequestEntry.setter(Builder::explicitHashKey)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitHashKey").build()).build();
    private static final SdkField<String> PARTITION_KEY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("PartitionKey").getter(PutRecordsRequestEntry.getter(PutRecordsRequestEntry::partitionKey)).setter(PutRecordsRequestEntry.setter(Builder::partitionKey)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKey").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, EXPLICIT_HASH_KEY_FIELD, PARTITION_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes data;
    private final String explicitHashKey;
    private final String partitionKey;

    private PutRecordsRequestEntry(BuilderImpl builder) {
        this.data = builder.data;
        this.explicitHashKey = builder.explicitHashKey;
        this.partitionKey = builder.partitionKey;
    }

    public final SdkBytes data() {
        return this.data;
    }

    public final String explicitHashKey() {
        return this.explicitHashKey;
    }

    public final String partitionKey() {
        return this.partitionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.explicitHashKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsRequestEntry)) {
            return false;
        }
        PutRecordsRequestEntry other = (PutRecordsRequestEntry)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.explicitHashKey(), other.explicitHashKey()) && Objects.equals(this.partitionKey(), other.partitionKey());
    }

    public final String toString() {
        return ToString.builder("PutRecordsRequestEntry").add("Data", this.data()).add("ExplicitHashKey", this.explicitHashKey()).add("PartitionKey", this.partitionKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "ExplicitHashKey": {
                return Optional.ofNullable(clazz.cast(this.explicitHashKey()));
            }
            case "PartitionKey": {
                return Optional.ofNullable(clazz.cast(this.partitionKey()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordsRequestEntry, T> g) {
        return obj -> g.apply((PutRecordsRequestEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes data;
        private String explicitHashKey;
        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsRequestEntry model) {
            this.data(model.data);
            this.explicitHashKey(model.explicitHashKey);
            this.partitionKey(model.partitionKey);
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        public final String getExplicitHashKey() {
            return this.explicitHashKey;
        }

        @Override
        public final Builder explicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
            return this;
        }

        public final void setExplicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        @Override
        public PutRecordsRequestEntry build() {
            return new PutRecordsRequestEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PutRecordsRequestEntry> {
        public Builder data(SdkBytes var1);

        public Builder explicitHashKey(String var1);

        public Builder partitionKey(String var1);
    }
}

