/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkBytes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, PutRecordRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamName").getter(PutRecordRequest.getter(PutRecordRequest::streamName)).setter(PutRecordRequest.setter(Builder::streamName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.builder(MarshallingType.SDK_BYTES).memberName("Data").getter(PutRecordRequest.getter(PutRecordRequest::data)).setter(PutRecordRequest.setter(Builder::data)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();
    private static final SdkField<String> PARTITION_KEY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("PartitionKey").getter(PutRecordRequest.getter(PutRecordRequest::partitionKey)).setter(PutRecordRequest.setter(Builder::partitionKey)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKey").build()).build();
    private static final SdkField<String> EXPLICIT_HASH_KEY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ExplicitHashKey").getter(PutRecordRequest.getter(PutRecordRequest::explicitHashKey)).setter(PutRecordRequest.setter(Builder::explicitHashKey)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitHashKey").build()).build();
    private static final SdkField<String> SEQUENCE_NUMBER_FOR_ORDERING_FIELD = SdkField.builder(MarshallingType.STRING).memberName("SequenceNumberForOrdering").getter(PutRecordRequest.getter(PutRecordRequest::sequenceNumberForOrdering)).setter(PutRecordRequest.setter(Builder::sequenceNumberForOrdering)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumberForOrdering").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, DATA_FIELD, PARTITION_KEY_FIELD, EXPLICIT_HASH_KEY_FIELD, SEQUENCE_NUMBER_FOR_ORDERING_FIELD));
    private final String streamName;
    private final SdkBytes data;
    private final String partitionKey;
    private final String explicitHashKey;
    private final String sequenceNumberForOrdering;

    private PutRecordRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.data = builder.data;
        this.partitionKey = builder.partitionKey;
        this.explicitHashKey = builder.explicitHashKey;
        this.sequenceNumberForOrdering = builder.sequenceNumberForOrdering;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final SdkBytes data() {
        return this.data;
    }

    public final String partitionKey() {
        return this.partitionKey;
    }

    public final String explicitHashKey() {
        return this.explicitHashKey;
    }

    public final String sequenceNumberForOrdering() {
        return this.sequenceNumberForOrdering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.explicitHashKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumberForOrdering());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.partitionKey(), other.partitionKey()) && Objects.equals(this.explicitHashKey(), other.explicitHashKey()) && Objects.equals(this.sequenceNumberForOrdering(), other.sequenceNumberForOrdering());
    }

    public final String toString() {
        return ToString.builder("PutRecordRequest").add("StreamName", this.streamName()).add("Data", this.data()).add("PartitionKey", this.partitionKey()).add("ExplicitHashKey", this.explicitHashKey()).add("SequenceNumberForOrdering", this.sequenceNumberForOrdering()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "PartitionKey": {
                return Optional.ofNullable(clazz.cast(this.partitionKey()));
            }
            case "ExplicitHashKey": {
                return Optional.ofNullable(clazz.cast(this.explicitHashKey()));
            }
            case "SequenceNumberForOrdering": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumberForOrdering()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordRequest, T> g) {
        return obj -> g.apply((PutRecordRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private SdkBytes data;
        private String partitionKey;
        private String explicitHashKey;
        private String sequenceNumberForOrdering;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.data(model.data);
            this.partitionKey(model.partitionKey);
            this.explicitHashKey(model.explicitHashKey);
            this.sequenceNumberForOrdering(model.sequenceNumberForOrdering);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public final String getExplicitHashKey() {
            return this.explicitHashKey;
        }

        @Override
        public final Builder explicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
            return this;
        }

        public final void setExplicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
        }

        public final String getSequenceNumberForOrdering() {
            return this.sequenceNumberForOrdering;
        }

        @Override
        public final Builder sequenceNumberForOrdering(String sequenceNumberForOrdering) {
            this.sequenceNumberForOrdering = sequenceNumberForOrdering;
            return this;
        }

        public final void setSequenceNumberForOrdering(String sequenceNumberForOrdering) {
            this.sequenceNumberForOrdering = sequenceNumberForOrdering;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecordRequest> {
        public Builder streamName(String var1);

        public Builder data(SdkBytes var1);

        public Builder partitionKey(String var1);

        public Builder explicitHashKey(String var1);

        public Builder sequenceNumberForOrdering(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

