/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetShardIteratorRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, GetShardIteratorRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamName").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::streamName)).setter(GetShardIteratorRequest.setter(Builder::streamName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ShardId").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::shardId)).setter(GetShardIteratorRequest.setter(Builder::shardId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();
    private static final SdkField<String> SHARD_ITERATOR_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ShardIteratorType").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::shardIteratorTypeAsString)).setter(GetShardIteratorRequest.setter(Builder::shardIteratorType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardIteratorType").build()).build();
    private static final SdkField<String> STARTING_SEQUENCE_NUMBER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StartingSequenceNumber").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::startingSequenceNumber)).setter(GetShardIteratorRequest.setter(Builder::startingSequenceNumber)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingSequenceNumber").build()).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("Timestamp").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::timestamp)).setter(GetShardIteratorRequest.setter(Builder::timestamp)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, SHARD_ID_FIELD, SHARD_ITERATOR_TYPE_FIELD, STARTING_SEQUENCE_NUMBER_FIELD, TIMESTAMP_FIELD));
    private final String streamName;
    private final String shardId;
    private final String shardIteratorType;
    private final String startingSequenceNumber;
    private final Instant timestamp;

    private GetShardIteratorRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.timestamp = builder.timestamp;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String shardId() {
        return this.shardId;
    }

    public final ShardIteratorType shardIteratorType() {
        return ShardIteratorType.fromValue(this.shardIteratorType);
    }

    public final String shardIteratorTypeAsString() {
        return this.shardIteratorType;
    }

    public final String startingSequenceNumber() {
        return this.startingSequenceNumber;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardIteratorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.shardIteratorTypeAsString(), other.shardIteratorTypeAsString()) && Objects.equals(this.startingSequenceNumber(), other.startingSequenceNumber()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder("GetShardIteratorRequest").add("StreamName", this.streamName()).add("ShardId", this.shardId()).add("ShardIteratorType", this.shardIteratorTypeAsString()).add("StartingSequenceNumber", this.startingSequenceNumber()).add("Timestamp", this.timestamp()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "ShardIteratorType": {
                return Optional.ofNullable(clazz.cast(this.shardIteratorTypeAsString()));
            }
            case "StartingSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.startingSequenceNumber()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetShardIteratorRequest, T> g) {
        return obj -> g.apply((GetShardIteratorRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String shardId;
        private String shardIteratorType;
        private String startingSequenceNumber;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.shardId(model.shardId);
            this.shardIteratorType(model.shardIteratorType);
            this.startingSequenceNumber(model.startingSequenceNumber);
            this.timestamp(model.timestamp);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getShardIteratorType() {
            return this.shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType == null ? null : shardIteratorType.toString());
            return this;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        public final String getStartingSequenceNumber() {
            return this.startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetShardIteratorRequest> {
        public Builder streamName(String var1);

        public Builder shardId(String var1);

        public Builder shardIteratorType(String var1);

        public Builder shardIteratorType(ShardIteratorType var1);

        public Builder startingSequenceNumber(String var1);

        public Builder timestamp(Instant var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

