/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.eventstream.EventStreamAsyncResponseTransformer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.eventstream.EventStreamTaggedUnionPojoSupplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.exception.AwsServiceException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.ApiName;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.RequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojoBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.AttachHttpMetadataResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.HttpResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.VoidSdkResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricPublisher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.NoOpMetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.cbor.AwsCborProtocolFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.ExceptionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.AddTagsToStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeleteStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeLimitsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ExpiredNextTokenException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.InternalFailureException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.InvalidArgumentException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsAccessDeniedException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsDisabledException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsInvalidStateException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsNotFoundException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsOptInRequiredException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsThrottlingException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MergeShardsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ResourceInUseException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SplitShardResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardEventStream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersPublisher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.AddTagsToStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.CreateStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DecreaseStreamRetentionPeriodRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DeleteStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DeregisterStreamConsumerRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeLimitsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeStreamConsumerRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeStreamSummaryRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DisableEnhancedMonitoringRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.EnableEnhancedMonitoringRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.GetRecordsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.GetShardIteratorRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.IncreaseStreamRetentionPeriodRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListShardsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListStreamConsumersRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListStreamsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListTagsForStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.MergeShardsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.PutRecordRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.PutRecordsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.RegisterStreamConsumerRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.RemoveTagsFromStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.SplitShardRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.StartStreamEncryptionRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.StopStreamEncryptionRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.SubscribeToShardRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.UpdateShardCountRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.waiters.KinesisAsyncWaiter;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CompletableFutureUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.FunctionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkInternalApi
final class DefaultKinesisAsyncClient
implements KinesisAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKinesisAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsCborProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final Executor executor;
    private final AwsJsonProtocolFactory jsonProtocolFactory;
    private final ScheduledExecutorService executorService;

    protected DefaultKinesisAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsCborProtocolFactory.builder()).build();
        this.jsonProtocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executor = clientConfiguration.option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR);
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public final String serviceName() {
        return "kinesis";
    }

    @Override
    public CompletableFuture<AddTagsToStreamResponse> addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, addTagsToStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<AddTagsToStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToStream").withMarshaller(new AddTagsToStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(addTagsToStreamRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addTagsToStreamRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest createStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, createStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<CreateStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStream").withMarshaller(new CreateStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(createStreamRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStreamRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DecreaseStreamRetentionPeriodResponse> decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, decreaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecreaseStreamRetentionPeriod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecreaseStreamRetentionPeriodResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DecreaseStreamRetentionPeriodResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecreaseStreamRetentionPeriod").withMarshaller(new DecreaseStreamRetentionPeriodRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(decreaseStreamRetentionPeriodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = decreaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest deleteStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DeleteStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStream").withMarshaller(new DeleteStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(deleteStreamRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteStreamRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeregisterStreamConsumerResponse> deregisterStreamConsumer(DeregisterStreamConsumerRequest deregisterStreamConsumerRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, deregisterStreamConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterStreamConsumer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterStreamConsumerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DeregisterStreamConsumerResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterStreamConsumer").withMarshaller(new DeregisterStreamConsumerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(deregisterStreamConsumerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deregisterStreamConsumerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeLimitsResponse> describeLimits(DescribeLimitsRequest describeLimitsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeLimitsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLimitsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DescribeLimitsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLimits").withMarshaller(new DescribeLimitsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(describeLimitsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeLimitsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeStreamResponse> describeStream(DescribeStreamRequest describeStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DescribeStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStream").withMarshaller(new DescribeStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(describeStreamRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStreamRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeStreamConsumerResponse> describeStreamConsumer(DescribeStreamConsumerRequest describeStreamConsumerRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeStreamConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStreamConsumer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamConsumerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DescribeStreamConsumerResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamConsumer").withMarshaller(new DescribeStreamConsumerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(describeStreamConsumerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStreamConsumerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeStreamSummaryResponse> describeStreamSummary(DescribeStreamSummaryRequest describeStreamSummaryRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeStreamSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStreamSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamSummaryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DescribeStreamSummaryResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamSummary").withMarshaller(new DescribeStreamSummaryRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(describeStreamSummaryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStreamSummaryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DisableEnhancedMonitoringResponse> disableEnhancedMonitoring(DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableEnhancedMonitoringRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableEnhancedMonitoring");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableEnhancedMonitoringResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DisableEnhancedMonitoringResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableEnhancedMonitoring").withMarshaller(new DisableEnhancedMonitoringRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(disableEnhancedMonitoringRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableEnhancedMonitoringRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<EnableEnhancedMonitoringResponse> enableEnhancedMonitoring(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableEnhancedMonitoringRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableEnhancedMonitoring");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableEnhancedMonitoringResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<EnableEnhancedMonitoringResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableEnhancedMonitoring").withMarshaller(new EnableEnhancedMonitoringRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(enableEnhancedMonitoringRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = enableEnhancedMonitoringRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetRecordsResponse> getRecords(GetRecordsRequest getRecordsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRecordsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecordsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<GetRecordsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecords").withMarshaller(new GetRecordsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(getRecordsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRecordsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetShardIteratorResponse> getShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, getShardIteratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetShardIterator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetShardIteratorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<GetShardIteratorResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetShardIterator").withMarshaller(new GetShardIteratorRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(getShardIteratorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getShardIteratorRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<IncreaseStreamRetentionPeriodResponse> increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, increaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "IncreaseStreamRetentionPeriod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IncreaseStreamRetentionPeriodResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<IncreaseStreamRetentionPeriodResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("IncreaseStreamRetentionPeriod").withMarshaller(new IncreaseStreamRetentionPeriodRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(increaseStreamRetentionPeriodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = increaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListShardsResponse> listShards(ListShardsRequest listShardsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, listShardsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListShards");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListShardsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<ListShardsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListShards").withMarshaller(new ListShardsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(listShardsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listShardsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListStreamConsumersResponse> listStreamConsumers(ListStreamConsumersRequest listStreamConsumersRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStreamConsumersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamConsumers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamConsumersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<ListStreamConsumersResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamConsumers").withMarshaller(new ListStreamConsumersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(listStreamConsumersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStreamConsumersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public ListStreamConsumersPublisher listStreamConsumersPaginator(ListStreamConsumersRequest listStreamConsumersRequest) {
        return new ListStreamConsumersPublisher(this, this.applyPaginatorUserAgent(listStreamConsumersRequest));
    }

    @Override
    public CompletableFuture<ListStreamsResponse> listStreams(ListStreamsRequest listStreamsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStreamsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreams");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<ListStreamsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreams").withMarshaller(new ListStreamsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(listStreamsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStreamsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForStreamResponse> listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<ListTagsForStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForStream").withMarshaller(new ListTagsForStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(listTagsForStreamRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForStreamRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<MergeShardsResponse> mergeShards(MergeShardsRequest mergeShardsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, mergeShardsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "MergeShards");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeShardsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<MergeShardsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeShards").withMarshaller(new MergeShardsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(mergeShardsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = mergeShardsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<PutRecordResponse> putRecord(PutRecordRequest putRecordRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, putRecordRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRecord");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecordResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<PutRecordResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecord").withMarshaller(new PutRecordRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(putRecordRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putRecordRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<PutRecordsResponse> putRecords(PutRecordsRequest putRecordsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, putRecordsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecordsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<PutRecordsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecords").withMarshaller(new PutRecordsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(putRecordsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putRecordsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<RegisterStreamConsumerResponse> registerStreamConsumer(RegisterStreamConsumerRequest registerStreamConsumerRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, registerStreamConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterStreamConsumer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterStreamConsumerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<RegisterStreamConsumerResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterStreamConsumer").withMarshaller(new RegisterStreamConsumerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(registerStreamConsumerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = registerStreamConsumerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsFromStreamResponse> removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<RemoveTagsFromStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromStream").withMarshaller(new RemoveTagsFromStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(removeTagsFromStreamRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeTagsFromStreamRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<SplitShardResponse> splitShard(SplitShardRequest splitShardRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, splitShardRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SplitShard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SplitShardResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<SplitShardResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SplitShard").withMarshaller(new SplitShardRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(splitShardRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = splitShardRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StartStreamEncryptionResponse> startStreamEncryption(StartStreamEncryptionRequest startStreamEncryptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, startStreamEncryptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartStreamEncryption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartStreamEncryptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<StartStreamEncryptionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartStreamEncryption").withMarshaller(new StartStreamEncryptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(startStreamEncryptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startStreamEncryptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StopStreamEncryptionResponse> stopStreamEncryption(StopStreamEncryptionRequest stopStreamEncryptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopStreamEncryptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopStreamEncryption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopStreamEncryptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<StopStreamEncryptionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopStreamEncryption").withMarshaller(new StopStreamEncryptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(stopStreamEncryptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopStreamEncryptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<Void> subscribeToShard(SubscribeToShardRequest subscribeToShardRequest, SubscribeToShardResponseHandler asyncResponseHandler) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, subscribeToShardRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SubscribeToShard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            AttachHttpMetadataResponseHandler responseHandler = new AttachHttpMetadataResponseHandler(this.jsonProtocolFactory.createResponseHandler(operationMetadata, SubscribeToShardResponse::builder));
            HttpResponseHandler voidResponseHandler = this.jsonProtocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(false).hasStreamingSuccessResponse(true).build(), VoidSdkResponse::builder);
            HttpResponseHandler eventResponseHandler = this.jsonProtocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(true).hasStreamingSuccessResponse(false).build(), EventStreamTaggedUnionPojoSupplier.builder().putSdkPojoSupplier("SubscribeToShardEvent", SubscribeToShardEventStream::subscribeToShardEventBuilder).defaultSdkPojoSupplier(() -> new SdkPojoBuilder<SubscribeToShardEventStream>(SubscribeToShardEventStream.UNKNOWN)).build());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.jsonProtocolFactory, operationMetadata);
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            EventStreamAsyncResponseTransformer<SubscribeToShardResponse, SubscribeToShardEventStream> asyncResponseTransformer = EventStreamAsyncResponseTransformer.builder().eventStreamResponseHandler(asyncResponseHandler).eventResponseHandler(eventResponseHandler).initialResponseHandler(responseHandler).exceptionResponseHandler(errorResponseHandler).future(future).executor(this.executor).serviceName(this.serviceName()).build();
            CompletableFuture<Void> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubscribeToShard").withMarshaller(new SubscribeToShardRequestMarshaller(this.jsonProtocolFactory)).withResponseHandler(voidResponseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(subscribeToShardRequest), asyncResponseTransformer);
            AwsRequestOverrideConfiguration requestOverrideConfig = subscribeToShardRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                if (e != null) {
                    try {
                        asyncResponseHandler.exceptionOccurred((Throwable)e);
                    }
                    finally {
                        future.completeExceptionally((Throwable)e);
                    }
                }
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return CompletableFutureUtils.forwardExceptionTo(future, executeFuture);
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseHandler.exceptionOccurred(t));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateShardCountResponse> updateShardCount(UpdateShardCountRequest updateShardCountRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateShardCountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateShardCount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateShardCountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<UpdateShardCountResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateShardCount").withMarshaller(new UpdateShardCountRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(updateShardCountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateShardCountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return ((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)builder.clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(KinesisException::builder)).protocol(AwsJsonProtocol.AWS_JSON)).protocolVersion("1.1")).registerModeledException(ExceptionMetadata.builder().errorCode("KMSThrottlingException").exceptionBuilderSupplier(KmsThrottlingException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").exceptionBuilderSupplier(KmsInvalidStateException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSNotFoundException").exceptionBuilderSupplier(KmsNotFoundException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").exceptionBuilderSupplier(ExpiredIteratorException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSOptInRequired").exceptionBuilderSupplier(KmsOptInRequiredException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").exceptionBuilderSupplier(KmsAccessDeniedException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSDisabledException").exceptionBuilderSupplier(KmsDisabledException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").exceptionBuilderSupplier(ExpiredNextTokenException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends KinesisRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.16.86").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build());
        return (T)((KinesisRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public KinesisAsyncWaiter waiter() {
        return KinesisAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }
}

