/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.internal.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkSystemSetting;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util.UserAgentUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util.ResourcesEndpointProvider;

@SdkInternalApi
public final class InstanceProviderTokenEndpointProvider
implements ResourcesEndpointProvider {
    private static final String TOKEN_RESOURCE_PATH = "/latest/api/token";
    private static final String EC2_METADATA_TOKEN_TTL_HEADER = "x-aws-ec2-metadata-token-ttl-seconds";
    private static final String DEFAULT_TOKEN_TTL = "21600";

    @Override
    public URI endpoint() {
        String host = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT.getStringValueOrThrow();
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        return URI.create(host + TOKEN_RESOURCE_PATH);
    }

    @Override
    public Map<String, String> headers() {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("User-Agent", UserAgentUtils.getUserAgent());
        requestHeaders.put("Accept", "*/*");
        requestHeaders.put("Connection", "keep-alive");
        requestHeaders.put(EC2_METADATA_TOKEN_TTL_HEADER, DEFAULT_TOKEN_TTL);
        return requestHeaders;
    }
}

