/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.marshall;

import java.net.URI;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.OperationInfo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.StructuredJsonGenerator;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.marshall.JsonProtocolMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.marshall.NullAsEmptyBodyProtocolRequestMarshaller;

@SdkInternalApi
public final class JsonProtocolMarshallerBuilder {
    private URI endpoint;
    private StructuredJsonGenerator jsonGenerator;
    private String contentType;
    private OperationInfo operationInfo;
    private boolean sendExplicitNullForPayload;

    private JsonProtocolMarshallerBuilder() {
    }

    public static JsonProtocolMarshallerBuilder create() {
        return new JsonProtocolMarshallerBuilder();
    }

    public JsonProtocolMarshallerBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public JsonProtocolMarshallerBuilder jsonGenerator(StructuredJsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
        return this;
    }

    public JsonProtocolMarshallerBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public JsonProtocolMarshallerBuilder operationInfo(OperationInfo operationInfo) {
        this.operationInfo = operationInfo;
        return this;
    }

    public JsonProtocolMarshallerBuilder sendExplicitNullForPayload(boolean sendExplicitNullForPayload) {
        this.sendExplicitNullForPayload = sendExplicitNullForPayload;
        return this;
    }

    public ProtocolMarshaller<SdkHttpFullRequest> build() {
        JsonProtocolMarshaller protocolMarshaller = new JsonProtocolMarshaller(this.endpoint, this.jsonGenerator, this.contentType, this.operationInfo);
        return this.sendExplicitNullForPayload ? protocolMarshaller : new NullAsEmptyBodyProtocolRequestMarshaller(protocolMarshaller);
    }
}

