/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.SdkArrayNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.SdkEmbeddedObject;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.SdkJsonNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.SdkNullNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.SdkObjectNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.SdkScalarNode;

@SdkInternalApi
public final class JsonDomParser {
    private final JsonFactory jsonFactory;

    private JsonDomParser(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public SdkJsonNode parse(InputStream content) throws IOException {
        try (JsonParser parser = this.jsonFactory.createParser(content).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);){
            SdkJsonNode sdkJsonNode = this.parseToken(parser, parser.nextToken());
            return sdkJsonNode;
        }
    }

    private SdkJsonNode parseToken(JsonParser parser, JsonToken token) throws IOException {
        if (token == null) {
            return null;
        }
        switch (token) {
            case VALUE_EMBEDDED_OBJECT: {
                return SdkEmbeddedObject.create(parser.getEmbeddedObject());
            }
            case VALUE_STRING: {
                return SdkScalarNode.create(parser.getText());
            }
            case VALUE_FALSE: {
                return SdkScalarNode.create("false");
            }
            case VALUE_TRUE: {
                return SdkScalarNode.create("true");
            }
            case VALUE_NULL: {
                return SdkNullNode.instance();
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return SdkScalarNode.create(parser.getNumberValue().toString());
            }
            case START_OBJECT: {
                return this.parseObject(parser);
            }
            case START_ARRAY: {
                return this.parseArray(parser);
            }
        }
        throw SdkClientException.create("Unexpected JSON token - " + (Object)((Object)token));
    }

    private SdkJsonNode parseObject(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.nextToken();
        SdkObjectNode.Builder builder = SdkObjectNode.builder();
        while (currentToken != JsonToken.END_OBJECT) {
            String fieldName = parser.getText();
            builder.putField(fieldName, this.parseToken(parser, parser.nextToken()));
            currentToken = parser.nextToken();
        }
        return builder.build();
    }

    private SdkJsonNode parseArray(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.nextToken();
        SdkArrayNode.Builder builder = SdkArrayNode.builder();
        while (currentToken != JsonToken.END_ARRAY) {
            builder.addItem(this.parseToken(parser, currentToken));
            currentToken = parser.nextToken();
        }
        return builder.build();
    }

    public static JsonDomParser create(JsonFactory jsonFactory) {
        return new JsonDomParser(jsonFactory);
    }
}

