/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.JsonDomParser;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.SdkJsonNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.SdkObjectNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkProtectedApi
public class JsonContent {
    private static final Logger LOG = LoggerFactory.getLogger(JsonContent.class);
    private final byte[] rawContent;
    private final SdkJsonNode jsonNode;

    JsonContent(byte[] rawJsonContent, SdkJsonNode jsonNode) {
        this.rawContent = rawJsonContent;
        this.jsonNode = jsonNode;
    }

    private JsonContent(byte[] rawJsonContent, JsonFactory jsonFactory) {
        this.rawContent = rawJsonContent;
        this.jsonNode = JsonContent.parseJsonContent(rawJsonContent, jsonFactory);
    }

    public static JsonContent createJsonContent(SdkHttpFullResponse httpResponse, JsonFactory jsonFactory) {
        byte[] rawJsonContent = httpResponse.content().map(c -> {
            try {
                return IoUtils.toByteArray(c);
            }
            catch (IOException e) {
                LOG.debug("Unable to read HTTP response content", (Throwable)e);
                return null;
            }
        }).orElse(null);
        return new JsonContent(rawJsonContent, jsonFactory);
    }

    private static SdkJsonNode parseJsonContent(byte[] rawJsonContent, JsonFactory jsonFactory) {
        if (rawJsonContent == null || rawJsonContent.length == 0) {
            return SdkObjectNode.emptyObject();
        }
        try {
            JsonDomParser parser = JsonDomParser.create(jsonFactory);
            return parser.parse(new ByteArrayInputStream(rawJsonContent));
        }
        catch (Exception e) {
            LOG.debug("Unable to parse HTTP response content", (Throwable)e);
            return SdkObjectNode.emptyObject();
        }
    }

    public byte[] getRawContent() {
        return this.rawContent;
    }

    public SdkJsonNode getJsonNode() {
        return this.jsonNode;
    }
}

