/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.http2;

import java.nio.charset.StandardCharsets;
import org.apache.flink.kinesis.shaded.io.netty.buffer.ByteBuf;
import org.apache.flink.kinesis.shaded.io.netty.channel.Channel;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.http2.GoAwayException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.http2.Http2MultiplexedChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class Http2GoAwayEventListener
extends Http2ConnectionAdapter {
    private static final Logger log = Logger.loggerFor(Http2GoAwayEventListener.class);
    private final Channel parentChannel;

    public Http2GoAwayEventListener(Channel parentChannel) {
        this.parentChannel = parentChannel;
    }

    @Override
    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        Http2MultiplexedChannelPool channelPool = this.parentChannel.attr(ChannelAttributeKey.HTTP2_MULTIPLEXED_CHANNEL_POOL).get();
        GoAwayException exception = new GoAwayException(errorCode, debugData.toString(StandardCharsets.UTF_8));
        if (channelPool != null) {
            channelPool.handleGoAway(this.parentChannel, lastStreamId, exception);
        } else {
            log.warn(() -> "GOAWAY received on a connection (" + this.parentChannel + ") not associated with any multiplexed channel pool.");
            this.parentChannel.pipeline().fireExceptionCaught(exception);
        }
    }
}

