/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal;

import java.io.IOException;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandler;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.FutureCancelledException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.RequestContext;

@ChannelHandler.Sharable
@SdkInternalApi
public final class FutureCancelHandler
extends ChannelInboundHandlerAdapter {
    private static final FutureCancelHandler INSTANCE = new FutureCancelHandler();

    private FutureCancelHandler() {
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (this.cancelled(ctx, e)) {
            RequestContext requestContext = ctx.channel().attr(ChannelAttributeKey.REQUEST_CONTEXT_KEY).get();
            requestContext.handler().onError(e);
            ctx.fireExceptionCaught(new IOException("Request cancelled"));
            ctx.close();
            requestContext.channelPool().release(ctx.channel());
        } else {
            ctx.fireExceptionCaught(e);
        }
    }

    public static FutureCancelHandler getInstance() {
        return INSTANCE;
    }

    private boolean cancelled(ChannelHandlerContext ctx, Throwable t) {
        if (!(t instanceof FutureCancelledException)) {
            return false;
        }
        FutureCancelledException e = (FutureCancelledException)t;
        return e.getExecutionId() == ctx.channel().attr(ChannelAttributeKey.EXECUTION_ID_KEY).get().longValue();
    }
}

