/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal;

import java.net.InetSocketAddress;
import org.apache.flink.kinesis.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.SdkChannelOptions;

@SdkInternalApi
public class BootstrapProvider {
    private final SdkEventLoopGroup sdkEventLoopGroup;
    private final NettyConfiguration nettyConfiguration;
    private final SdkChannelOptions sdkChannelOptions;

    BootstrapProvider(SdkEventLoopGroup sdkEventLoopGroup, NettyConfiguration nettyConfiguration, SdkChannelOptions sdkChannelOptions) {
        this.sdkEventLoopGroup = sdkEventLoopGroup;
        this.nettyConfiguration = nettyConfiguration;
        this.sdkChannelOptions = sdkChannelOptions;
    }

    public Bootstrap createBootstrap(String host, int port) {
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.sdkEventLoopGroup.eventLoopGroup())).channelFactory(this.sdkEventLoopGroup.channelFactory())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.nettyConfiguration.connectTimeoutMillis())).option(ChannelOption.SO_KEEPALIVE, this.nettyConfiguration.tcpKeepAlive())).remoteAddress(InetSocketAddress.createUnresolved(host, port));
        this.sdkChannelOptions.channelOptions().forEach(bootstrap::option);
        return bootstrap;
    }
}

