/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.flink.kinesis.shaded.io.netty.channel.Channel;
import org.apache.flink.kinesis.shaded.io.netty.channel.pool.ChannelPool;
import org.apache.flink.kinesis.shaded.io.netty.channel.pool.ChannelPoolHandler;
import org.apache.flink.kinesis.shaded.io.netty.handler.ssl.SslContext;
import org.apache.flink.kinesis.shaded.io.netty.handler.ssl.SslProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkTestInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.Protocol;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.BetterSimpleChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.BootstrapProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.CancellableAcquireChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ChannelPipelineInitializer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.HandlerRemovingChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.HealthCheckedChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.HonorCloseOnReleaseChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.Http1TunnelConnectionPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ReleaseOnceChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.SdkChannelOptions;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.SdkChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.SdkChannelPoolMap;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.SimpleChannelPoolAwareChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.SslContextProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.http2.HttpOrHttp2ChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class AwaitCloseChannelPoolMap
extends SdkChannelPoolMap<URI, SimpleChannelPoolAwareChannelPool> {
    private static final Logger log = Logger.loggerFor(AwaitCloseChannelPoolMap.class);
    private static final ChannelPoolHandler NOOP_HANDLER = new ChannelPoolHandler(){

        @Override
        public void channelReleased(Channel ch) throws Exception {
        }

        @Override
        public void channelAcquired(Channel ch) throws Exception {
        }

        @Override
        public void channelCreated(Channel ch) throws Exception {
        }
    };
    private static final Function<Builder, BootstrapProvider> DEFAULT_BOOTSTRAP_PROVIDER = b -> new BootstrapProvider(((Builder)b).sdkEventLoopGroup, ((Builder)b).configuration, ((Builder)b).sdkChannelOptions);
    private final Map<URI, Boolean> shouldProxyForHostCache = new ConcurrentHashMap<URI, Boolean>();
    private final NettyConfiguration configuration;
    private final Protocol protocol;
    private final long maxStreams;
    private final Duration healthCheckPingPeriod;
    private final int initialWindowSize;
    private final SslProvider sslProvider;
    private final ProxyConfiguration proxyConfiguration;
    private final BootstrapProvider bootstrapProvider;
    private final SslContextProvider sslContextProvider;

    private AwaitCloseChannelPoolMap(Builder builder, Function<Builder, BootstrapProvider> createBootStrapProvider) {
        this.configuration = builder.configuration;
        this.protocol = builder.protocol;
        this.maxStreams = builder.maxStreams;
        this.healthCheckPingPeriod = builder.healthCheckPingPeriod;
        this.initialWindowSize = builder.initialWindowSize;
        this.sslProvider = builder.sslProvider;
        this.proxyConfiguration = builder.proxyConfiguration;
        this.bootstrapProvider = createBootStrapProvider.apply(builder);
        this.sslContextProvider = new SslContextProvider(this.configuration, this.protocol, this.sslProvider);
    }

    private AwaitCloseChannelPoolMap(Builder builder) {
        this(builder, DEFAULT_BOOTSTRAP_PROVIDER);
    }

    @SdkTestInternalApi
    AwaitCloseChannelPoolMap(Builder builder, Map<URI, Boolean> shouldProxyForHostCache, BootstrapProvider bootstrapProvider) {
        this(builder, bootstrapProvider == null ? DEFAULT_BOOTSTRAP_PROVIDER : b -> bootstrapProvider);
        if (shouldProxyForHostCache != null) {
            this.shouldProxyForHostCache.putAll(shouldProxyForHostCache);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected SimpleChannelPoolAwareChannelPool newPool(URI key) {
        ChannelPool baseChannelPool;
        BetterSimpleChannelPool tcpChannelPool;
        SslContext sslContext = this.needSslContext(key) ? this.sslContextProvider.sslContext() : null;
        Bootstrap bootstrap = this.createBootstrap(key);
        AtomicReference<ChannelPool> channelPoolRef = new AtomicReference<ChannelPool>();
        ChannelPipelineInitializer pipelineInitializer = new ChannelPipelineInitializer(this.protocol, sslContext, this.sslProvider, this.maxStreams, this.initialWindowSize, this.healthCheckPingPeriod, channelPoolRef, this.configuration, key);
        if (this.shouldUseProxyForHost(key)) {
            tcpChannelPool = new BetterSimpleChannelPool(bootstrap, NOOP_HANDLER);
            baseChannelPool = new Http1TunnelConnectionPool(bootstrap.config().group().next(), tcpChannelPool, sslContext, this.proxyAddress(key), key, pipelineInitializer);
        } else {
            baseChannelPool = tcpChannelPool = new BetterSimpleChannelPool(bootstrap, pipelineInitializer);
        }
        SdkChannelPool wrappedPool = this.wrapBaseChannelPool(bootstrap, baseChannelPool);
        channelPoolRef.set(wrappedPool);
        return new SimpleChannelPoolAwareChannelPool(wrappedPool, tcpChannelPool);
    }

    @Override
    public void close() {
        log.trace(() -> "Closing channel pools");
        Collection channelPools = this.pools().values();
        super.close();
        try {
            CompletableFuture.allOf((CompletableFuture[])channelPools.stream().map(pool -> pool.underlyingSimpleChannelPool().closeFuture()).toArray(CompletableFuture[]::new)).get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private Bootstrap createBootstrap(URI poolKey) {
        String host = this.bootstrapHost(poolKey);
        int port = this.bootstrapPort(poolKey);
        return this.bootstrapProvider.createBootstrap(host, port);
    }

    private boolean shouldUseProxyForHost(URI remoteAddr) {
        if (this.proxyConfiguration == null) {
            return false;
        }
        return this.shouldProxyForHostCache.computeIfAbsent(remoteAddr, uri -> this.proxyConfiguration.nonProxyHosts().stream().noneMatch(h -> uri.getHost().matches((String)h)));
    }

    private String bootstrapHost(URI remoteHost) {
        if (this.shouldUseProxyForHost(remoteHost)) {
            return this.proxyConfiguration.host();
        }
        return remoteHost.getHost();
    }

    private int bootstrapPort(URI remoteHost) {
        if (this.shouldUseProxyForHost(remoteHost)) {
            return this.proxyConfiguration.port();
        }
        return remoteHost.getPort();
    }

    private URI proxyAddress(URI remoteHost) {
        if (!this.shouldUseProxyForHost(remoteHost)) {
            return null;
        }
        String scheme = this.proxyConfiguration.scheme();
        if (scheme == null) {
            scheme = "http";
        }
        try {
            return new URI(scheme, null, this.proxyConfiguration.host(), this.proxyConfiguration.port(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to construct proxy URI", e);
        }
    }

    private SdkChannelPool wrapBaseChannelPool(Bootstrap bootstrap, ChannelPool channelPool) {
        channelPool = new HonorCloseOnReleaseChannelPool(channelPool);
        SdkChannelPool sdkChannelPool = new HttpOrHttp2ChannelPool(channelPool, bootstrap.config().group(), this.configuration.maxConnections(), this.configuration);
        sdkChannelPool = new HandlerRemovingChannelPool(sdkChannelPool);
        sdkChannelPool = new ReleaseOnceChannelPool(sdkChannelPool);
        sdkChannelPool = new HealthCheckedChannelPool(bootstrap.config().group(), this.configuration, sdkChannelPool);
        sdkChannelPool = new CancellableAcquireChannelPool(bootstrap.config().group().next(), sdkChannelPool);
        return sdkChannelPool;
    }

    private boolean needSslContext(URI targetAddress) {
        URI proxyAddress = this.proxyAddress(targetAddress);
        boolean needContext = targetAddress.getScheme().equalsIgnoreCase("https") || proxyAddress != null && proxyAddress.getScheme().equalsIgnoreCase("https");
        return needContext;
    }

    public static class Builder {
        private SdkChannelOptions sdkChannelOptions;
        private SdkEventLoopGroup sdkEventLoopGroup;
        private NettyConfiguration configuration;
        private Protocol protocol;
        private long maxStreams;
        private int initialWindowSize;
        private Duration healthCheckPingPeriod;
        private SslProvider sslProvider;
        private ProxyConfiguration proxyConfiguration;

        private Builder() {
        }

        public Builder sdkChannelOptions(SdkChannelOptions sdkChannelOptions) {
            this.sdkChannelOptions = sdkChannelOptions;
            return this;
        }

        public Builder sdkEventLoopGroup(SdkEventLoopGroup sdkEventLoopGroup) {
            this.sdkEventLoopGroup = sdkEventLoopGroup;
            return this;
        }

        public Builder configuration(NettyConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder maxStreams(long maxStreams) {
            this.maxStreams = maxStreams;
            return this;
        }

        public Builder initialWindowSize(int initialWindowSize) {
            this.initialWindowSize = initialWindowSize;
            return this;
        }

        public Builder healthCheckPingPeriod(Duration healthCheckPingPeriod) {
            this.healthCheckPingPeriod = healthCheckPingPeriod;
            return this;
        }

        public Builder sslProvider(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
            return this;
        }

        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public AwaitCloseChannelPoolMap build() {
            return new AwaitCloseChannelPoolMap(this);
        }
    }
}

