/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.Immutable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.AbortableInputStream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.DefaultSdkHttpFullResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkProtectedApi
@Immutable
public interface SdkHttpFullResponse
extends SdkHttpResponse {
    public static Builder builder() {
        return new DefaultSdkHttpFullResponse.Builder();
    }

    @Override
    public Builder toBuilder();

    public Optional<AbortableInputStream> content();

    public static interface Builder
    extends SdkHttpResponse.Builder {
        @Override
        public String statusText();

        @Override
        public Builder statusText(String var1);

        @Override
        public int statusCode();

        @Override
        public Builder statusCode(int var1);

        @Override
        public Map<String, List<String>> headers();

        @Override
        default public Optional<String> firstMatchingHeader(String header) {
            return SdkHttpUtils.firstMatchingHeader(this.headers(), header);
        }

        @Override
        default public Builder putHeader(String headerName, String headerValue) {
            return this.putHeader(headerName, (List)Collections.singletonList(headerValue));
        }

        @Override
        public Builder putHeader(String var1, List<String> var2);

        @Override
        public Builder appendHeader(String var1, String var2);

        @Override
        public Builder headers(Map<String, List<String>> var1);

        @Override
        public Builder removeHeader(String var1);

        @Override
        public Builder clearHeaders();

        public AbortableInputStream content();

        public Builder content(AbortableInputStream var1);

        @Override
        public SdkHttpFullResponse build();
    }
}

