/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.util.json;

import java.io.IOException;
import java.io.Writer;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonParseException;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;

@SdkProtectedApi
public final class JacksonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter WRITER = OBJECT_MAPPER.writer();
    private static final ObjectWriter PRETTY_WRITER = OBJECT_MAPPER.writerWithDefaultPrettyPrinter();

    private JacksonUtils() {
    }

    public static String toJsonPrettyString(Object value) {
        try {
            return PRETTY_WRITER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String toJsonString(Object value) {
        try {
            return WRITER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to parse Json String.").cause(e).build();
        }
    }

    public static <T> T fromSensitiveJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            if (e instanceof JsonParseException) {
                ((JsonParseException)e).clearLocation();
            }
            throw SdkClientException.builder().message("Unable to parse Json String.").cause(e).build();
        }
    }

    public static JsonNode jsonNodeOf(String json) {
        return JacksonUtils.fromJsonString(json, JsonNode.class);
    }

    public static JsonNode sensitiveJsonNodeOf(String json) {
        return JacksonUtils.fromSensitiveJsonString(json, JsonNode.class);
    }

    public static JsonGenerator jsonGeneratorOf(Writer writer) throws IOException {
        return new JsonFactory().createGenerator(writer);
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

