/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.runtime.transform;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.async.AsyncRequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.transform.AbstractStreamingRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.StringUtils;

@SdkProtectedApi
public final class AsyncStreamingRequestMarshaller<T>
extends AbstractStreamingRequestMarshaller<T> {
    private final AsyncRequestBody asyncRequestBody;

    private AsyncStreamingRequestMarshaller(Builder builder) {
        super(builder);
        this.asyncRequestBody = builder.asyncRequestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public SdkHttpFullRequest marshall(T in) {
        SdkHttpFullRequest.Builder marshalled = this.delegateMarshaller.marshall(in).toBuilder();
        String contentType = marshalled.firstMatchingHeader("Content-Type").orElse(null);
        if (StringUtils.isEmpty(contentType)) {
            marshalled.putHeader("Content-Type", this.asyncRequestBody.contentType());
        }
        this.addHeaders(marshalled, this.asyncRequestBody.contentLength(), this.requiresLength, this.transferEncoding, this.useHttp2);
        return marshalled.build();
    }

    public static final class Builder
    extends AbstractStreamingRequestMarshaller.Builder<Builder> {
        private AsyncRequestBody asyncRequestBody;

        public Builder asyncRequestBody(AsyncRequestBody asyncRequestBody) {
            this.asyncRequestBody = asyncRequestBody;
            return this;
        }

        public <T> AsyncStreamingRequestMarshaller<T> build() {
            return new AsyncStreamingRequestMarshaller(this);
        }
    }
}

