/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util;

import java.util.Optional;
import java.util.jar.JarInputStream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.JavaSystemSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@SdkInternalApi
public final class UserAgentUtils {
    private static final String UA_STRING = "aws-sdk-{platform}/{version} {os.name}/{os.version} {java.vm.name}/{java.vm.version} Java/{java.version}{language.and.region}{additional.languages} vendor/{java.vendor}";
    private static final String UA_BLACKLIST_REGEX = "[() ,/:;<=>?@\\[\\]{}\\\\]";
    private static final Logger log = LoggerFactory.getLogger(UserAgentUtils.class);
    private static final String UNKNOWN = "unknown";
    private static volatile String userAgent;

    private UserAgentUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent() {
        if (userAgent != null) return userAgent;
        Class<UserAgentUtils> clazz = UserAgentUtils.class;
        synchronized (UserAgentUtils.class) {
            if (userAgent != null) return userAgent;
            UserAgentUtils.initializeUserAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userAgent;
        }
    }

    private static void initializeUserAgent() {
        userAgent = UserAgentUtils.userAgent();
    }

    static String userAgent() {
        String ua = UA_STRING;
        ua = ua.replace("{platform}", "java").replace("{version}", "2.16.86").replace("{os.name}", UserAgentUtils.sanitizeInput(JavaSystemSetting.OS_NAME.getStringValue().orElse(null))).replace("{os.version}", UserAgentUtils.sanitizeInput(JavaSystemSetting.OS_VERSION.getStringValue().orElse(null))).replace("{java.vm.name}", UserAgentUtils.sanitizeInput(JavaSystemSetting.JAVA_VM_NAME.getStringValue().orElse(null))).replace("{java.vm.version}", UserAgentUtils.sanitizeInput(JavaSystemSetting.JAVA_VM_VERSION.getStringValue().orElse(null))).replace("{java.version}", UserAgentUtils.sanitizeInput(JavaSystemSetting.JAVA_VERSION.getStringValue().orElse(null))).replace("{java.vendor}", UserAgentUtils.sanitizeInput(JavaSystemSetting.JAVA_VENDOR.getStringValue().orElse(null))).replace("{additional.languages}", UserAgentUtils.getAdditionalJvmLanguages());
        Optional<String> language = JavaSystemSetting.USER_LANGUAGE.getStringValue();
        Optional<String> region = JavaSystemSetting.USER_REGION.getStringValue();
        String languageAndRegion = "";
        if (language.isPresent() && region.isPresent()) {
            languageAndRegion = " (" + UserAgentUtils.sanitizeInput(language.get()) + "_" + UserAgentUtils.sanitizeInput(region.get()) + ")";
        }
        ua = ua.replace("{language.and.region}", languageAndRegion);
        return ua;
    }

    private static String sanitizeInput(String input) {
        return input == null ? UNKNOWN : input.replaceAll(UA_BLACKLIST_REGEX, "_");
    }

    private static String getAdditionalJvmLanguages() {
        return UserAgentUtils.concat(UserAgentUtils.concat("", UserAgentUtils.scalaVersion(), " "), UserAgentUtils.kotlinVersion(), " ");
    }

    private static String scalaVersion() {
        String scalaVersion;
        block3: {
            scalaVersion = "";
            try {
                Class<?> scalaProperties = Class.forName("scala.util.Properties");
                scalaVersion = "scala";
                String version = (String)scalaProperties.getMethod("versionNumberString", new Class[0]).invoke(null, new Object[0]);
                scalaVersion = UserAgentUtils.concat(scalaVersion, version, "/");
            }
            catch (ClassNotFoundException scalaProperties) {
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Exception attempting to get Scala version.", (Throwable)e);
            }
        }
        return scalaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String kotlinVersion() {
        String kotlinVersion = "";
        JarInputStream kotlinJar = null;
        try {
            Class<?> kotlinUnit = Class.forName("kotlin.Unit");
            kotlinVersion = "kotlin";
            kotlinJar = new JarInputStream(kotlinUnit.getProtectionDomain().getCodeSource().getLocation().openStream());
            String version = kotlinJar.getManifest().getMainAttributes().getValue("Implementation-Version");
            kotlinVersion = UserAgentUtils.concat(kotlinVersion, version, "/");
            IoUtils.closeQuietly(kotlinJar, log);
        }
        catch (ClassNotFoundException kotlinUnit) {
            IoUtils.closeQuietly(kotlinJar, log);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception attempting to get Kotlin version.", (Throwable)e);
            }
        }
        finally {
            IoUtils.closeQuietly(kotlinJar, log);
        }
        return kotlinVersion;
    }

    private static String concat(String prefix, String suffix, String separator) {
        return suffix != null && !suffix.isEmpty() ? prefix + separator + suffix : prefix;
    }
}

