/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.interceptor;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.async.AsyncRequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.Context;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.sync.RequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Md5Utils;

@SdkInternalApi
public class HttpChecksumRequiredInterceptor
implements ExecutionInterceptor {
    private static final ExecutionAttribute<String> CONTENT_MD5_VALUE = new ExecutionAttribute("ContentMd5");

    @Override
    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        boolean isHttpChecksumRequired = this.isHttpChecksumRequired(executionAttributes);
        boolean requestAlreadyHasMd5 = context.httpRequest().firstMatchingHeader("Content-MD5").isPresent();
        Optional<RequestBody> syncContent = context.requestBody();
        Optional<AsyncRequestBody> asyncContent = context.asyncRequestBody();
        if (!isHttpChecksumRequired || requestAlreadyHasMd5) {
            return;
        }
        if (asyncContent.isPresent()) {
            throw new IllegalArgumentException("This operation requires a content-MD5 checksum, but one cannot be calculated for non-blocking content.");
        }
        syncContent.ifPresent(requestBody -> this.saveContentMd5((RequestBody)requestBody, executionAttributes));
    }

    @Override
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        String contentMd5 = executionAttributes.getAttribute(CONTENT_MD5_VALUE);
        if (contentMd5 != null) {
            return (SdkHttpRequest)context.httpRequest().copy(r -> r.putHeader("Content-MD5", contentMd5));
        }
        return context.httpRequest();
    }

    private boolean isHttpChecksumRequired(ExecutionAttributes executionAttributes) {
        return executionAttributes.getAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED) != null;
    }

    private void saveContentMd5(RequestBody requestBody, ExecutionAttributes executionAttributes) {
        try {
            String payloadMd5 = Md5Utils.md5AsBase64(requestBody.contentStreamProvider().newStream());
            executionAttributes.putAttribute(CONTENT_MD5_VALUE, payloadMd5);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

