/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.MutableRequestToRequestPipeline;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public class MergeCustomHeadersStage
implements MutableRequestToRequestPipeline {
    private final SdkClientConfiguration config;

    public MergeCustomHeadersStage(HttpClientDependencies dependencies) {
        this.config = dependencies.clientConfiguration();
    }

    @Override
    public SdkHttpFullRequest.Builder execute(SdkHttpFullRequest.Builder request, RequestExecutionContext context) throws Exception {
        return request.headers((Map)this.mergeHeaders(request.headers(), this.config.option(SdkClientOption.ADDITIONAL_HTTP_HEADERS), this.adaptHeaders(context.requestConfig().headers())));
    }

    @SafeVarargs
    private final Map<String, List<String>> mergeHeaders(Map<String, List<String>> ... headers) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (Map<String, List<String>> header : headers) {
            header.forEach((headerName, headerValues) -> {
                List resultHeaderValues = result.computeIfAbsent((String)headerName, ignored -> new ArrayList());
                if (SdkHttpUtils.isSingleHeader(headerName)) {
                    resultHeaderValues.clear();
                }
                resultHeaderValues.addAll(headerValues);
            });
        }
        return result;
    }

    private Map<String, List<String>> adaptHeaders(Map<String, List<String>> toConvert) {
        TreeMap<String, List<String>> adapted = new TreeMap<String, List<String>>();
        toConvert.forEach((name, value) -> {
            List cfr_ignored_0 = adapted.put((String)name, new ArrayList(value));
        });
        return adapted;
    }
}

