/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.ApiName;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.ClientType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkSystemSetting;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.MutableRequestToRequestPipeline;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util.UserAgentUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.StringUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public class ApplyUserAgentStage
implements MutableRequestToRequestPipeline {
    private static final String COMMA = ", ";
    private static final String SPACE = " ";
    private static final String IO = "io";
    private static final String HTTP = "http";
    private static final String CONFIG = "cfg";
    private static final String RETRY_MODE = "retry-mode";
    private static final String AWS_EXECUTION_ENV_PREFIX = "exec-env/";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private final SdkClientConfiguration clientConfig;

    public ApplyUserAgentStage(HttpClientDependencies dependencies) {
        this.clientConfig = dependencies.clientConfiguration();
    }

    @Override
    public SdkHttpFullRequest.Builder execute(SdkHttpFullRequest.Builder request, RequestExecutionContext context) throws Exception {
        StringBuilder userAgentBuilder = this.getUserAgent(this.clientConfig, context.requestConfig().apiNames());
        String userAgent = this.addUserAgentSuffix(userAgentBuilder, this.clientConfig);
        return request.putHeader(HEADER_USER_AGENT, userAgent);
    }

    private StringBuilder getUserAgent(SdkClientConfiguration config, List<ApiName> requestApiNames) {
        ClientType clientType;
        String internalUserAgent;
        String userDefinedPrefix = config.option(SdkAdvancedClientOption.USER_AGENT_PREFIX);
        String awsExecutionEnvironment = SdkSystemSetting.AWS_EXECUTION_ENV.getStringValue().orElse(null);
        StringBuilder userAgent = new StringBuilder(StringUtils.trimToEmpty(userDefinedPrefix));
        String systemUserAgent = UserAgentUtils.getUserAgent();
        if (!systemUserAgent.equals(userDefinedPrefix)) {
            userAgent.append(COMMA).append(systemUserAgent);
        }
        if (!(internalUserAgent = StringUtils.trimToEmpty(this.clientConfig.option(SdkClientOption.INTERNAL_USER_AGENT))).isEmpty()) {
            userAgent.append(SPACE).append(internalUserAgent);
        }
        if (!StringUtils.isEmpty(awsExecutionEnvironment)) {
            userAgent.append(SPACE).append(AWS_EXECUTION_ENV_PREFIX).append(awsExecutionEnvironment.trim());
        }
        if ((clientType = this.clientConfig.option(SdkClientOption.CLIENT_TYPE)) == null) {
            clientType = ClientType.UNKNOWN;
        }
        userAgent.append(SPACE).append(IO).append("/").append(StringUtils.lowerCase(clientType.name()));
        String clientName = this.clientName(clientType);
        userAgent.append(SPACE).append(HTTP).append("/").append(SdkHttpUtils.urlEncode(clientName));
        String retryMode = config.option(SdkClientOption.RETRY_POLICY).retryMode().toString();
        userAgent.append(SPACE).append(CONFIG).append("/").append(RETRY_MODE).append("/").append(StringUtils.lowerCase(retryMode));
        if (!requestApiNames.isEmpty()) {
            String requestUserAgent = requestApiNames.stream().map(n -> n.name() + "/" + n.version()).collect(Collectors.joining(SPACE));
            userAgent.append(SPACE).append(requestUserAgent);
        }
        return userAgent;
    }

    private String addUserAgentSuffix(StringBuilder userAgent, SdkClientConfiguration config) {
        String userDefinedSuffix = config.option(SdkAdvancedClientOption.USER_AGENT_SUFFIX);
        if (!StringUtils.isEmpty(userDefinedSuffix)) {
            userAgent.append(COMMA).append(userDefinedSuffix.trim());
        }
        return userAgent.toString();
    }

    private String clientName(ClientType clientType) {
        if (clientType.equals((Object)ClientType.SYNC)) {
            return this.clientConfig.option(SdkClientOption.SYNC_HTTP_CLIENT).clientName();
        }
        if (clientType.equals((Object)ClientType.ASYNC)) {
            return this.clientConfig.option(SdkClientOption.ASYNC_HTTP_CLIENT).clientName();
        }
        return ClientType.UNKNOWN.name();
    }
}

