/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.handler;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.Response;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.SyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.AbortedException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.NonRetryableException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.RetryableException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.ExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.HttpResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.InterceptorContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.handler.BaseClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.AmazonSyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.CombinedResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.InterruptMonitor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.sync.RequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.sync.ResponseTransformer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.AbortableInputStream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public abstract class BaseSyncClientHandler
extends BaseClientHandler
implements SyncClientHandler {
    private final SdkClientConfiguration clientConfiguration;
    private final AmazonSyncHttpClient client;

    protected BaseSyncClientHandler(SdkClientConfiguration clientConfiguration, AmazonSyncHttpClient client) {
        super(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.client = client;
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> ReturnT execute(ClientExecutionParams<InputT, OutputT> executionParams, ResponseTransformer<OutputT, ReturnT> responseTransformer) {
        return (ReturnT)this.measureApiCallSuccess(executionParams, () -> {
            BaseSyncClientHandler.validateExecutionParams(executionParams);
            if (executionParams.getCombinedResponseHandler() != null) {
                throw new IllegalArgumentException("A streaming 'responseTransformer' may not be used when a 'combinedResponseHandler' has been specified in a ClientExecutionParams object.");
            }
            ExecutionAttributes overrideAttributes = this.addExecutionAttributeOverrides(executionParams);
            ExecutionAttributes executionAttributes = BaseSyncClientHandler.addInitialExecutionAttributes(overrideAttributes);
            ExecutionContext executionContext = this.createExecutionContext(executionParams, executionAttributes);
            HttpResponseHandler decoratedResponseHandlers = this.decorateResponseHandlers(executionParams.getResponseHandler(), executionContext);
            HttpResponseHandlerAdapter httpResponseHandler = new HttpResponseHandlerAdapter(decoratedResponseHandlers, responseTransformer);
            return this.doExecute(executionParams, executionContext, new CombinedResponseHandler(httpResponseHandler, executionParams.getErrorResponseHandler()));
        });
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse> OutputT execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        return (OutputT)this.measureApiCallSuccess(executionParams, () -> {
            HttpResponseHandler combinedResponseHandler;
            BaseSyncClientHandler.validateExecutionParams(executionParams);
            ExecutionAttributes overrideAttributes = this.addExecutionAttributeOverrides(executionParams);
            ExecutionAttributes executionAttributes = BaseSyncClientHandler.addInitialExecutionAttributes(overrideAttributes);
            ExecutionContext executionContext = this.createExecutionContext(executionParams, executionAttributes);
            if (executionParams.getCombinedResponseHandler() != null) {
                combinedResponseHandler = this.decorateSuccessResponseHandlers(executionParams.getCombinedResponseHandler(), executionContext);
            } else {
                HttpResponseHandler decoratedResponseHandlers = this.decorateResponseHandlers(executionParams.getResponseHandler(), executionContext);
                combinedResponseHandler = new CombinedResponseHandler(decoratedResponseHandlers, executionParams.getErrorResponseHandler());
            }
            return (SdkResponse)this.doExecute(executionParams, executionContext, combinedResponseHandler);
        });
    }

    @Override
    public void close() {
        this.client.close();
    }

    private <OutputT> OutputT invoke(SdkHttpFullRequest request, SdkRequest originalRequest, ExecutionContext executionContext, HttpResponseHandler<Response<OutputT>> responseHandler) {
        return this.client.requestExecutionBuilder().request(request).originalRequest(originalRequest).executionContext(executionContext).execute(responseHandler);
    }

    private <InputT extends SdkRequest, OutputT, ReturnT> ReturnT doExecute(ClientExecutionParams<InputT, OutputT> executionParams, ExecutionContext executionContext, HttpResponseHandler<Response<ReturnT>> responseHandler) {
        SdkRequest inputT = BaseSyncClientHandler.finalizeSdkRequest(executionContext).request();
        InterceptorContext sdkHttpFullRequestContext = BaseSyncClientHandler.finalizeSdkHttpFullRequest(executionParams, executionContext, inputT, this.clientConfiguration);
        SdkHttpFullRequest marshalled = (SdkHttpFullRequest)sdkHttpFullRequestContext.httpRequest();
        Optional<RequestBody> requestBody = sdkHttpFullRequestContext.requestBody();
        if (requestBody.isPresent()) {
            marshalled = marshalled.toBuilder().contentStreamProvider(requestBody.get().contentStreamProvider()).build();
        }
        return (ReturnT)this.invoke(marshalled, inputT, executionContext, responseHandler);
    }

    private <T> T measureApiCallSuccess(ClientExecutionParams<?, ?> executionParams, Supplier<T> thingToMeasureSuccessOf) {
        try {
            T result = thingToMeasureSuccessOf.get();
            this.reportApiCallSuccess(executionParams, true);
            return result;
        }
        catch (Exception e) {
            this.reportApiCallSuccess(executionParams, false);
            throw e;
        }
    }

    private void reportApiCallSuccess(ClientExecutionParams<?, ?> executionParams, boolean value) {
        MetricCollector metricCollector = executionParams.getMetricCollector();
        if (metricCollector != null) {
            metricCollector.reportMetric(CoreMetric.API_CALL_SUCCESSFUL, value);
        }
    }

    private static class HttpResponseHandlerAdapter<ReturnT, OutputT extends SdkResponse>
    implements HttpResponseHandler<ReturnT> {
        private final HttpResponseHandler<OutputT> httpResponseHandler;
        private final ResponseTransformer<OutputT, ReturnT> responseTransformer;

        private HttpResponseHandlerAdapter(HttpResponseHandler<OutputT> httpResponseHandler, ResponseTransformer<OutputT, ReturnT> responseTransformer) {
            this.httpResponseHandler = httpResponseHandler;
            this.responseTransformer = responseTransformer;
        }

        @Override
        public ReturnT handle(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) throws Exception {
            SdkResponse resp = (SdkResponse)this.httpResponseHandler.handle(response, executionAttributes);
            return this.transformResponse(resp, response.content().orElse(null));
        }

        @Override
        public boolean needsConnectionLeftOpen() {
            return this.responseTransformer.needsConnectionLeftOpen();
        }

        private ReturnT transformResponse(OutputT resp, AbortableInputStream inputStream) throws Exception {
            try {
                InterruptMonitor.checkInterrupted();
                ReturnT result = this.responseTransformer.transform(resp, inputStream);
                InterruptMonitor.checkInterrupted();
                return result;
            }
            catch (InterruptedException | AbortedException | RetryableException e) {
                throw e;
            }
            catch (Exception e) {
                InterruptMonitor.checkInterrupted();
                throw NonRetryableException.builder().cause(e).build();
            }
        }
    }
}

