/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.handler;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.Response;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.async.AsyncRequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.async.AsyncResponseTransformer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.Crc32Validation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.ExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.HttpResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.InterceptorContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.InternalCoreExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.handler.BaseClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.AmazonAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.IdempotentAsyncResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.async.AsyncAfterTransmissionInterceptorCallingResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.async.AsyncResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.async.AsyncStreamingResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.async.CombinedResponseAsyncHttpResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util.ThrowableUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.sync.RequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CompletableFutureUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.FunctionalUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public abstract class BaseAsyncClientHandler
extends BaseClientHandler
implements AsyncClientHandler {
    private static final Logger log = Logger.loggerFor(BaseAsyncClientHandler.class);
    private final SdkClientConfiguration clientConfiguration;
    private final AmazonAsyncHttpClient client;
    private final Function<SdkHttpFullResponse, SdkHttpFullResponse> crc32Validator;

    protected BaseAsyncClientHandler(SdkClientConfiguration clientConfiguration, AmazonAsyncHttpClient client) {
        super(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.client = client;
        this.crc32Validator = response -> Crc32Validation.validate(this.isCalculateCrc32FromCompressedData(), response);
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse> CompletableFuture<OutputT> execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        return this.measureApiCallSuccess(executionParams, () -> {
            BaseAsyncClientHandler.validateExecutionParams(executionParams);
            ExecutionAttributes overrideAttributes = this.addExecutionAttributeOverrides(executionParams);
            ExecutionAttributes executionAttributes = BaseAsyncClientHandler.addInitialExecutionAttributes(overrideAttributes);
            ExecutionContext executionContext = this.createExecutionContext(executionParams, executionAttributes);
            TransformingAsyncResponseHandler<Response<Object>> combinedResponseHandler = executionParams.getCombinedResponseHandler() == null ? this.createDecoratedHandler(executionParams.getResponseHandler(), executionParams.getErrorResponseHandler(), executionContext) : this.createDecoratedHandler(executionParams.getCombinedResponseHandler(), executionContext);
            return this.doExecute(executionParams, executionContext, combinedResponseHandler);
        });
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> CompletableFuture<ReturnT> execute(ClientExecutionParams<InputT, OutputT> executionParams, AsyncResponseTransformer<OutputT, ReturnT> asyncResponseTransformer) {
        return this.measureApiCallSuccess(executionParams, () -> {
            BaseAsyncClientHandler.validateExecutionParams(executionParams);
            if (executionParams.getCombinedResponseHandler() != null) {
                throw new IllegalArgumentException("A streaming 'asyncResponseTransformer' may not be used when a 'combinedResponseHandler' has been specified in a ClientExecutionParams object.");
            }
            ExecutionAttributes overrideAttributes = this.addExecutionAttributeOverrides(executionParams);
            ExecutionAttributes executionAttributes = BaseAsyncClientHandler.addInitialExecutionAttributes(overrideAttributes);
            AsyncStreamingResponseHandler asyncStreamingResponseHandler = new AsyncStreamingResponseHandler(asyncResponseTransformer);
            IdempotentAsyncResponseHandler wrappedAsyncStreamingResponseHandler = IdempotentAsyncResponseHandler.create(asyncStreamingResponseHandler, () -> executionAttributes.getAttribute(InternalCoreExecutionAttribute.EXECUTION_ATTEMPT), Integer::equals);
            wrappedAsyncStreamingResponseHandler.prepare();
            ExecutionContext context = this.createExecutionContext(executionParams, executionAttributes);
            HttpResponseHandler decoratedResponseHandlers = this.decorateResponseHandlers(executionParams.getResponseHandler(), context);
            asyncStreamingResponseHandler.responseHandler(decoratedResponseHandlers);
            TransformingAsyncResponseHandler<? extends SdkException> errorHandler = this.resolveErrorResponseHandler(executionParams.getErrorResponseHandler(), context, this.crc32Validator);
            CombinedResponseAsyncHttpResponseHandler combinedResponseHandler = new CombinedResponseAsyncHttpResponseHandler(wrappedAsyncStreamingResponseHandler, errorHandler);
            return this.doExecute(executionParams, context, combinedResponseHandler);
        });
    }

    private <OutputT extends SdkResponse> TransformingAsyncResponseHandler<Response<OutputT>> createDecoratedHandler(HttpResponseHandler<OutputT> successHandler, HttpResponseHandler<? extends SdkException> errorHandler, ExecutionContext executionContext) {
        HttpResponseHandler<OutputT> decoratedResponseHandlers = this.decorateResponseHandlers(successHandler, executionContext);
        AsyncResponseHandler<OutputT> decoratedSuccessHandler = new AsyncResponseHandler<OutputT>(decoratedResponseHandlers, this.crc32Validator, executionContext.executionAttributes());
        TransformingAsyncResponseHandler<? extends SdkException> decoratedErrorHandler = this.resolveErrorResponseHandler(errorHandler, executionContext, this.crc32Validator);
        return new CombinedResponseAsyncHttpResponseHandler<OutputT>(decoratedSuccessHandler, decoratedErrorHandler);
    }

    private <OutputT extends SdkResponse> TransformingAsyncResponseHandler<Response<OutputT>> createDecoratedHandler(HttpResponseHandler<Response<OutputT>> combinedResponseHandler, ExecutionContext executionContext) {
        HttpResponseHandler<Response<OutputT>> decoratedResponseHandlers = this.decorateSuccessResponseHandlers(combinedResponseHandler, executionContext);
        return new AsyncResponseHandler<Response<OutputT>>(decoratedResponseHandlers, this.crc32Validator, executionContext.executionAttributes());
    }

    private <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> CompletableFuture<ReturnT> doExecute(ClientExecutionParams<InputT, OutputT> executionParams, ExecutionContext executionContext, TransformingAsyncResponseHandler<Response<ReturnT>> asyncResponseHandler) {
        try {
            InterceptorContext finalizeSdkRequestContext = BaseAsyncClientHandler.finalizeSdkRequest(executionContext);
            SdkRequest inputT = finalizeSdkRequestContext.request();
            InterceptorContext finalizeSdkHttpRequestContext = BaseAsyncClientHandler.finalizeSdkHttpFullRequest(executionParams, executionContext, inputT, this.clientConfiguration);
            SdkHttpFullRequest marshalled = (SdkHttpFullRequest)finalizeSdkHttpRequestContext.httpRequest();
            Optional<RequestBody> requestBody = finalizeSdkHttpRequestContext.requestBody();
            if (!finalizeSdkHttpRequestContext.asyncRequestBody().isPresent() && requestBody.isPresent()) {
                marshalled = marshalled.toBuilder().contentStreamProvider(requestBody.get().contentStreamProvider()).build();
            }
            CompletableFuture<OutputT> invokeFuture = this.invoke(marshalled, finalizeSdkHttpRequestContext.asyncRequestBody().orElse(null), inputT, executionContext, new AsyncAfterTransmissionInterceptorCallingResponseHandler<Response<OutputT>>(asyncResponseHandler, executionContext));
            CompletionStage exceptionTranslatedFuture = invokeFuture.handle((resp, err) -> {
                if (err != null) {
                    throw ThrowableUtils.failure(err);
                }
                return resp;
            });
            return CompletableFutureUtils.forwardExceptionTo(exceptionTranslatedFuture, invokeFuture);
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError(log.logger(), "Error thrown from TransformingAsyncResponseHandler#onError, ignoring.", () -> asyncResponseHandler.onError(t));
            return CompletableFutureUtils.failedFuture(ThrowableUtils.asSdkException(t));
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    private TransformingAsyncResponseHandler<? extends SdkException> resolveErrorResponseHandler(HttpResponseHandler<? extends SdkException> errorHandler, ExecutionContext executionContext, Function<SdkHttpFullResponse, SdkHttpFullResponse> responseAdapter) {
        return new AsyncResponseHandler<SdkException>(errorHandler, responseAdapter, executionContext.executionAttributes());
    }

    private <InputT extends SdkRequest, OutputT> CompletableFuture<OutputT> invoke(SdkHttpFullRequest request, AsyncRequestBody requestProvider, InputT originalRequest, ExecutionContext executionContext, TransformingAsyncResponseHandler<Response<OutputT>> responseHandler) {
        return this.client.requestExecutionBuilder().requestProvider(requestProvider).request(request).originalRequest(originalRequest).executionContext(executionContext).execute(responseHandler);
    }

    private <T> CompletableFuture<T> measureApiCallSuccess(ClientExecutionParams<?, ?> executionParams, Supplier<CompletableFuture<T>> apiCall) {
        try {
            CompletableFuture<T> apiCallResult = apiCall.get();
            CompletionStage outputFuture = apiCallResult.whenComplete((r, t) -> this.reportApiCallSuccess(executionParams, t == null));
            CompletableFutureUtils.forwardExceptionTo(outputFuture, apiCallResult);
            return outputFuture;
        }
        catch (Exception e) {
            this.reportApiCallSuccess(executionParams, false);
            throw e;
        }
    }

    private void reportApiCallSuccess(ClientExecutionParams<?, ?> executionParams, boolean value) {
        MetricCollector metricCollector = executionParams.getMetricCollector();
        if (metricCollector != null) {
            metricCollector.reportMetric(CoreMetric.API_CALL_SUCCESSFUL, value);
        }
    }
}

