/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.handler;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.Immutable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.handler.AwsClientHandlerUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.internal.client.config.AwsClientOptionValidation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.SdkSyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.SyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.Crc32Validation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.ExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.HttpResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.sync.ResponseTransformer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;

@ThreadSafe
@Immutable
@SdkProtectedApi
public final class AwsSyncClientHandler
extends SdkSyncClientHandler
implements SyncClientHandler {
    private final SdkClientConfiguration clientConfiguration;

    public AwsSyncClientHandler(SdkClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        AwsClientOptionValidation.validateSyncClientOptions(clientConfiguration);
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse> OutputT execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        ClientExecutionParams<InputT, OutputT> clientExecutionParams = this.addCrc32Validation(executionParams);
        return super.execute(clientExecutionParams);
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> ReturnT execute(ClientExecutionParams<InputT, OutputT> executionParams, ResponseTransformer<OutputT, ReturnT> responseTransformer) {
        return super.execute(executionParams, responseTransformer);
    }

    @Override
    protected <InputT extends SdkRequest, OutputT extends SdkResponse> ExecutionContext createExecutionContext(ClientExecutionParams<InputT, OutputT> executionParams, ExecutionAttributes executionAttributes) {
        return AwsClientHandlerUtils.createExecutionContext(executionParams, this.clientConfiguration, executionAttributes);
    }

    private <InputT extends SdkRequest, OutputT> ClientExecutionParams<InputT, OutputT> addCrc32Validation(ClientExecutionParams<InputT, OutputT> executionParams) {
        if (executionParams.getCombinedResponseHandler() != null) {
            return executionParams.withCombinedResponseHandler(new Crc32ValidationResponseHandler(executionParams.getCombinedResponseHandler()));
        }
        return executionParams.withResponseHandler(new Crc32ValidationResponseHandler(executionParams.getResponseHandler()));
    }

    private class Crc32ValidationResponseHandler<T>
    implements HttpResponseHandler<T> {
        private final HttpResponseHandler<T> delegate;

        private Crc32ValidationResponseHandler(HttpResponseHandler<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T handle(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) throws Exception {
            return this.delegate.handle(Crc32Validation.validate(AwsSyncClientHandler.this.isCalculateCrc32FromCompressedData(), response), executionAttributes);
        }
    }
}

