/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.handler;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.config.AwsAdvancedClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.config.AwsClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.RequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.ExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptorChain;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.InterceptorContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CollectionUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;
import org.apache.flink.kinesis.shaded.software.amazon.eventstream.HeaderValue;
import org.apache.flink.kinesis.shaded.software.amazon.eventstream.Message;

@SdkProtectedApi
public final class AwsClientHandlerUtils {
    private AwsClientHandlerUtils() {
    }

    static <InputT extends SdkRequest, OutputT extends SdkResponse> ExecutionContext createExecutionContext(ClientExecutionParams<InputT, OutputT> executionParams, SdkClientConfiguration clientConfig, ExecutionAttributes executionAttributes) {
        InputT originalRequest = executionParams.getInput();
        AwsCredentialsProvider clientCredentials = clientConfig.option(AwsClientOption.CREDENTIALS_PROVIDER);
        AwsCredentialsProvider credentialsProvider = ((SdkRequest)originalRequest).overrideConfiguration().filter(c -> c instanceof AwsRequestOverrideConfiguration).map(c -> (AwsRequestOverrideConfiguration)c).flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElse(clientCredentials);
        long credentialsResolveStart = System.nanoTime();
        AwsCredentials credentials = credentialsProvider.resolveCredentials();
        Duration fetchDuration = Duration.ofNanos(System.nanoTime() - credentialsResolveStart);
        MetricCollector metricCollector = AwsClientHandlerUtils.resolveMetricCollector(executionParams);
        metricCollector.reportMetric(CoreMetric.CREDENTIALS_FETCH_DURATION, fetchDuration);
        Validate.validState(credentials != null, "Credential providers must never return null.", new Object[0]);
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG, clientConfig.option(SdkClientOption.SERVICE_CONFIGURATION)).putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, credentials).putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, clientConfig.option(AwsClientOption.SERVICE_SIGNING_NAME)).putAttribute(AwsExecutionAttribute.AWS_REGION, clientConfig.option(AwsClientOption.AWS_REGION)).putAttribute(AwsExecutionAttribute.ENDPOINT_PREFIX, clientConfig.option(AwsClientOption.ENDPOINT_PREFIX)).putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, clientConfig.option(AwsClientOption.SIGNING_REGION)).putAttribute(SdkInternalExecutionAttribute.IS_FULL_DUPLEX, executionParams.isFullDuplex()).putAttribute(SdkExecutionAttribute.CLIENT_TYPE, clientConfig.option(SdkClientOption.CLIENT_TYPE)).putAttribute(SdkExecutionAttribute.SERVICE_NAME, clientConfig.option(SdkClientOption.SERVICE_NAME)).putAttribute(SdkExecutionAttribute.OPERATION_NAME, executionParams.getOperationName()).putAttribute(SdkExecutionAttribute.CLIENT_ENDPOINT, clientConfig.option(SdkClientOption.ENDPOINT)).putAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN, clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN)).putAttribute(SdkInternalExecutionAttribute.DISABLE_HOST_PREFIX_INJECTION, clientConfig.option(SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION));
        ExecutionInterceptorChain executionInterceptorChain = new ExecutionInterceptorChain(clientConfig.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        return ExecutionContext.builder().interceptorChain(executionInterceptorChain).interceptorContext(InterceptorContext.builder().request((SdkRequest)originalRequest).asyncRequestBody(executionParams.getAsyncRequestBody()).requestBody(executionParams.getRequestBody()).build()).executionAttributes(executionAttributes).signer(AwsClientHandlerUtils.computeSigner(originalRequest, clientConfig)).metricCollector(metricCollector).build();
    }

    public static ByteBuffer encodeEventStreamRequestToByteBuffer(SdkHttpFullRequest request) {
        Map<String, HeaderValue> headers = request.headers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> HeaderValue.fromString((String)CollectionUtils.firstIfPresent((List)e.getValue()))));
        byte[] payload = null;
        if (request.contentStreamProvider().isPresent()) {
            try {
                payload = IoUtils.toByteArray(request.contentStreamProvider().get().newStream());
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        return new Message(headers, payload).toByteBuffer();
    }

    private static Signer computeSigner(SdkRequest originalRequest, SdkClientConfiguration clientConfiguration) {
        return (Signer)originalRequest.overrideConfiguration().flatMap(RequestOverrideConfiguration::signer).orElse(clientConfiguration.option(AwsAdvancedClientOption.SIGNER));
    }

    private static MetricCollector resolveMetricCollector(ClientExecutionParams<?, ?> params) {
        MetricCollector metricCollector = params.getMetricCollector();
        if (metricCollector == null) {
            metricCollector = MetricCollector.create("ApiCall");
        }
        return metricCollector;
    }
}

