/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.CredentialUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.internal.Aws4SignerRequestParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.internal.BaseAws4Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.internal.DigestComputingSubscriber;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.async.AsyncRequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.AsyncSigner;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.BinaryUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkPublicApi
public final class AsyncAws4Signer
extends BaseAws4Signer
implements AsyncSigner {
    @Override
    public CompletableFuture<SdkHttpFullRequest> sign(SdkHttpFullRequest request, AsyncRequestBody requestBody, ExecutionAttributes executionAttributes) {
        Aws4SignerParams signingParams = this.extractSignerParams(Aws4SignerParams.builder(), executionAttributes).build();
        return this.signWithBody(request, requestBody, signingParams);
    }

    public CompletableFuture<SdkHttpFullRequest> signWithBody(SdkHttpFullRequest request, AsyncRequestBody requestBody, Aws4SignerParams signingParams) {
        if (CredentialUtils.isAnonymous(signingParams.awsCredentials())) {
            return CompletableFuture.completedFuture(request);
        }
        DigestComputingSubscriber bodyDigester = DigestComputingSubscriber.forSha256();
        requestBody.subscribe(bodyDigester);
        CompletableFuture<byte[]> digestBytes = bodyDigester.digestBytes();
        CompletionStage signedReqFuture = digestBytes.thenApply(bodyHash -> {
            String digestHex = BinaryUtils.toHex(bodyHash);
            Aws4SignerRequestParams requestParams = new Aws4SignerRequestParams(signingParams);
            SdkHttpFullRequest.Builder builder = this.doSign(request, requestParams, signingParams, digestHex);
            return builder.build();
        });
        return CompletableFutureUtils.forwardExceptionTo(signedReqFuture, digestBytes);
    }

    public static AsyncAws4Signer create() {
        return new AsyncAws4Signer();
    }
}

