/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.RecordFormat;

@SdkInternalApi
public class RecordFormatMarshaller {
    private static final MarshallingInfo<String> RECORDFORMATTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormatType").build();
    private static final MarshallingInfo<StructuredPojo> MAPPINGPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MappingParameters").build();
    private static final RecordFormatMarshaller instance = new RecordFormatMarshaller();

    public static RecordFormatMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecordFormat recordFormat, ProtocolMarshaller protocolMarshaller) {
        if (recordFormat == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(recordFormat.getRecordFormatType(), RECORDFORMATTYPE_BINDING);
            protocolMarshaller.marshall(recordFormat.getMappingParameters(), MAPPINGPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

